<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithTitle;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\DB;

class ExportDay implements FromView, ShouldAutoSize, WithTitle
{
    protected $tgl_awal;
    protected $tgl_akhir;
    protected $institution;

    public function __construct(string $tgl_awal, string $tgl_akhir, string $institution)
    {
        $this->tgl_awal = $tgl_awal;
        $this->tgl_akhir = $tgl_akhir;
        $this->institution = $institution;
    }

    public function title(): string
    {
        return 'Laporan Tagihan';
    }
    public function view(): View
    {
        $paidBills = DB::table('bill_details as bd')
            ->leftJoin('bills as b', 'bd.bill_id', '=', 'b.id')
            ->leftJoin('bill_categories as bc', 'b.bill_category_id', '=', 'bc.id')
            ->join('payments as p', 'bd.id', '=', 'p.bill_detail_id')
            ->join('students as s', 'bd.student_id', '=', 's.id')
            ->leftJoin('school_years as sy', 'b.school_year_id', '=', 'sy.id')
            ->where('bd.status', 'PAID')
            ->where('b.institution_id', institution()->id)
            ->whereBetween(DB::raw('DATE(bd.updated_at)'), [$this->tgl_awal, $this->tgl_akhir])
            ->groupBy('bd.id', 's.name', 'b.name', 'bd.month', 'bd.amount', 'bd.updated_at', 'bd.actived_at', 'bc.name', 's.nis')
            ->select('bd.id', 's.name as nama_santri', 'b.name as deskripsi', 'bd.month as bulan', 'bd.amount as nominal', 'bd.updated_at as tanggal', DB::raw('MONTH(bd.actived_at) as bulan_aktif'), DB::raw('YEAR(bd.actived_at) as tahun_aktif'), 'bc.name as kategori', 's.nis as nis_santri')
            ->get();

        $viewData = [
            'data' => $paidBills,
        ];

        return view('pages.institution.report.finance.exportDay', $viewData);
    }
}
