<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithTitle;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\DB;

class ExportMonth implements FromView, ShouldAutoSize, WithTitle
{
    protected $tp;
    protected $bulan;
    protected $institution;

    public function __construct(int $tp, int $bulan, int $institution)
    {
        $this->tp = $tp;
        $this->bulan = $bulan;
        $this->institution = $institution;
    }

    public function title(): string
    {
        return 'Laporan Tagihan - ' . namaBulanIndonesia($this->bulan);
    }
    public function view(): View
    {
        $paidBills = DB::table('bill_details as bd')
            ->leftJoin('bills as b', 'b.id', '=', 'bd.bill_id')
            ->leftJoin('bill_categories as bc', 'b.bill_category_id', '=', 'bc.id')
            ->join('payments as p', 'bd.id', '=', 'p.bill_detail_id')
            ->join('students as s', 's.id', '=', 'bd.student_id')
            ->leftJoin('school_years as sy', 'sy.id', '=', 'b.school_year_id')
            ->where('bd.status', 'PAID')
            ->where('b.institution_id', $this->institution)
            ->whereMonth('bd.updated_at', $this->bulan)
            ->where('sy.id', $this->tp)
            ->groupBy('bd.id', 's.nis', 's.name', 'b.name', 'bd.amount', 'bd.updated_at',  'bd.actived_at', 'bc.name')
            ->select('bd.id', 's.name as nama_santri', 'b.name as deskripsi', 'bd.amount as nominal', 'bd.updated_at as tanggal', DB::raw('MONTH(bd.actived_at) as bulan_aktif'), DB::raw('YEAR(bd.actived_at) as tahun_aktif'), 'bc.name as kategori', 's.nis as nis_santri')
            ->get();

        $viewData = [
            'data' => $paidBills,
        ];

        return view('pages.institution.report.finance.exportMonth', $viewData);
    }
}
