<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Bill;
use App\Models\BillDetail;
use Illuminate\Http\Request;

class BillDetailApiController extends Controller
{
    public function billDetail($bill)
    {
        $billDetail = BillDetail::where('bill_id', $bill)->get();
        return datatables()->of($billDetail)->toJson();
    }
    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'category', 'school_year']);
        $originalName = $data['name'];
        $notif = ['status' => 'notif-success', 'description' => 'Berhasil update data!'];

        $notif = updateBasicTableFormatted(new Bill, $id, [
            'name' => $data['name'],
            'school_year_id' => $data['school_year'],
            'bill_category_id' => $data['category'],
        ], $notif, $originalName);

        // return redirect()
        //     ->route('institution.bill')
        //     ->with(
        //         $notif['status'],
        //         $notif['description']
        //     );
        return response()->json($notif);
    }
}
