<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Services\PaymentService;

class PaymentApiController extends Controller
{
    protected $paymentService;

    public function __construct(PaymentService $paymentService)
    {
        $this->paymentService = $paymentService;
    }

    public function index(Request $request)
    {
        return datatables()->of($this->paymentService->model()->get())->toJson();
    }

    public function store(Request $request)
    {
        $this->paymentService->store(
            $request->bill_detail_ids,
            $request->nis,
            $request->bank_account_number,
            $request->amounts,
            $request->description
        );

        return response()->json(['success' => true]);
    }
}
