<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Student;
use Illuminate\Http\Request;

class StudentApiController extends Controller
{
    public function index($id)
    {
        $students = Student::with('school_class')->whereHas('school_class', function ($query) use ($id) {
            $query->whereHas('educational_level', function ($query) use ($id) {
                $query->where('institution_id', $id);
            });
        })->get();
        return datatables()->of($students)->toJson();
    }
    public function byNis($nis)
    {
        $student = Student::where('nis', $nis)->get();
        return datatables()->of($student)->toJson();
    }
}
