<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\PasswordRequest;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class PasswordController extends Controller
{
    public function update(PasswordRequest $request)
    {
        try {
            $user = User::find(auth()->user()->id);

            if (
                $this->isPasswordValid($user, $request->old_password) &&
                $this->isConfirmedPassword($request->password, $request->password_confirmation)
            ) {
                $user->update([
                    'password' => bcrypt($request->password),
                ]);
            } else {
                return response()->json(['status' => 'failed'], 400);
            }

            return response()->json(['status' => 'success']);
        } catch (\Throwable $th) {
            return response()->json(['status' => 'failed'], 500);
        }
    }

    /**
     * old password same with current password
     * compare password with bcrypt
     */
    private function isPasswordValid($user, $oldPassword)
    {
        return Hash::check($oldPassword, $user->password);
    }

    /**
     * password same with password confirmation
     */
    private function isConfirmedPassword($password, $passwordConfirmation)
    {
        return $password === $passwordConfirmation;
    }
}
