<?php

namespace App\Http\Controllers\Bill;

use App\Http\Controllers\Controller;
use App\Models\Bill;
use App\Models\BillActive;
use App\Models\BillCategory;
use App\Models\BillDetail;
use App\Models\SchoolYear;
use App\Models\Student;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BillController extends Controller
{
    public function index()
    {
        $bills = Bill::where('institution_id', institution()->id)->get();
        $bill_categories = BillCategory::all();
        $school_years = SchoolYear::all();
        $idBillTable = 'bill-table';
        $headers = [
            '#',
            'Nama Tagihan',
            'Jenis',
        ];
        $no = 1;
        $rows = [];
        foreach ($bills as $bill) {
            $rows[] = [
                $no++,
                $bill->name,
                $bill->bill_category->name,
                $bill->id,
            ];
        }
        return view('pages.institution.bill.index', compact(
            'bill_categories',
            'school_years',
            'idBillTable',
            'headers',
            'rows'
        ));
    }

    public function show($id)
    {
        $bill = Bill::with('bill_detail', 'bill_category', 'school_year')
            ->where('id', $id)
            ->first();

        $billDetails = BillDetail::where('bill_id', $id)->get();

        $startYearMonth = [
            'july' => null,
            'august' => null,
            'september' => null,
            'october' => null,
            'november' => null,
            'december' => null,
        ];

        $endYearMonth = [
            'january'  => null,
            'february'  => null,
            'march'  => null,
            'april'  => null,
            'may'  => null,
            'june'  => null
        ];

        $amount = null;
        $activatedAt = null;

        $firstBillDetail = $billDetails->first();

        if ($firstBillDetail && $bill->bill_category->name == 'Bulanan') {
            $startYearMonth = [
                'july' => number_format($billDetails->where('month', 7)->first()->amount,  0, '.', '.'),
                'august' => number_format($billDetails->where('month', 8)->first()->amount, 0, '.', '.'),
                'september' => number_format($billDetails->where('month', 9)->first()->amount, 0, '.', '.'),
                'october' => number_format($billDetails->where('month', 10)->first()->amount, 0, '.', '.'),
                'november' => number_format($billDetails->where('month', 11)->first()->amount, 0, '.', '.'),
                'december' => number_format($billDetails->where('month', 12)->first()->amount, 0, '.', '.'),
            ];

            $endYearMonth = [
                'january'  => number_format($billDetails->where('month', 1)->first()->amount, 0, '.', '.'),
                'february'  => number_format($billDetails->where('month', 2)->first()->amount, 0, '.', '.'),
                'march'  => number_format($billDetails->where('month', 3)->first()->amount, 0, '.', '.'),
                'april'  => number_format($billDetails->where('month', 4)->first()->amount, 0, '.', '.'),
                'may'  => number_format($billDetails->where('month', 5)->first()->amount, 0, '.', '.'),
                'june'  => number_format($billDetails->where('month', 6)->first()->amount, 0, '.', '.')
            ];
        } elseif ($firstBillDetail) {
            $fixedBillDetails = BillDetail::with('student')->where('student_id', $firstBillDetail->student_id)
                ->where('bill_id', $firstBillDetail->bill_id)
                ->get();
            // $amount = number_format($fixedBillDetails->sum('amount'), 0, '.', '.');
            $amount = number_format($fixedBillDetails->count() < 2 ? $firstBillDetail->amount : $fixedBillDetails->sum('amount'), 0, '.', '.');
            // $amount = number_format($firstBillDetail->amount, 0, '.', '.');
            // $amount = $fixedBillDetails->first()->amount;
            $activatedAt = $firstBillDetail->actived_at;
        }

        $months['start'] = $startYearMonth;
        $months['end'] = $endYearMonth;

        return view('pages.institution.bill.show', compact(
            'bill',
            'billDetails',
            'months',
            'amount',
            'activatedAt'
        ));
    }



    public function edit($id)
    {
        $bill = Bill::where('id', $id)->first();

        return response()->json($bill);
    }

    public function store(Request $request)
    {
        $data = $request->only(['name', 'category', 'school_year']);
        $originalName = $data['name'];
        $notif = ['status' => 'notif-success', 'description' => 'Berhasil menambahkan data!'];

        $notif = insertBasicTableFormatted(new Bill, [
            'name' => $data['name'],
            'school_year_id' => $data['school_year'],
            'bill_category_id' => $data['category'],
            'institution_id' => institution()->id,
        ], $notif, $originalName);

        return redirect()
            ->route('institution.bill')
            ->with(
                $notif['status'],
                $notif['description']
            );
    }

    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'category', 'school_year']);
        $originalName = $data['name'];
        $notif = ['status' => 'notif-success', 'success' => true, 'description' => 'Berhasil update data!'];

        $notif = updateBasicTableFormatted(new Bill, $id, [
            'name' => $data['name'],
            'school_year_id' => $data['school_year'],
            'bill_category_id' => $data['category'],
        ], $notif, $originalName);

        return redirect()
            ->route('institution.bill')
            ->with(
                $notif['status'],
                $notif['description']
            );
    }

    public function destroy(Request $request)
    {
        $notif = ['status' => 'notif-success', 'success' => true, 'description' => 'Berhasil menghapus data!'];
        $ids = empty($request->ids) || !isset($request->ids) ? $request->id_confirm : $request->ids;

        // $notif = deleteBasicTableFormatted(new Bill, $id, $notif);

        $bill = new Bill;

        DB::beginTransaction();
        try {

            if (isset($ids[0]) && $ids[0] === 'on') {
                array_shift($ids);
            }

            if (is_array($ids) && count($ids) > 0) {
                $notif['ids'] = $ids;
                // $bill::whereIn('id', $ids)->delete();
                // get many bill
                $bills = $bill::with('bill_detail')->whereIn('id', $ids);
                // iteration bills
                foreach ($bills->get() as $bill) {
                    // check that's bill detail not PAID
                    foreach ($bill->bill_detail as $bill_detail) {
                        if ($bill_detail->status != 'PAID') {
                            BillDetail::findOrfail($bill_detail->id)->delete();
                        }
                    }
                }
                // when child data done delete
                // we can delete this bill
                $bills->delete();
            } else {
                // $bill::findOrFail($ids[0])->delete();
                $billFirst = $bill::with('bill_detail')->findOrFail($ids);
                foreach ($billFirst->bill_detail as $bill_detail) {
                    if ($bill_detail->status != 'PAID') {
                        BillDetail::findOrfail($bill_detail->id)->delete();
                    }
                }
                $billFirst->delete();
            }
        } catch (\Throwable $th) {
            // Jika terjadi kesalahan, rollback transaksi
            DB::rollBack();

            $notif['status'] = 'notif-error';
            $notif['success'] = false;

            $notif['description'] = $th->getMessage(); // Perubahan urutan

            if ($th->getCode() == 23000) {
                $notif['description'] = 'Sudah ada tagihan yang terbayar, tidak dapat dihapus!';
            } else {
                $notif['description'] = 'Gagal menghapus data, Silahkan coba lagi!';
            }
        } finally {
            DB::commit();
        }

        return response()->json($notif);
    }
}
