<?php

namespace App\Http\Controllers\Bill;

use App\Http\Controllers\Controller;
use App\Models\Bill;
use App\Models\BillCategory;
use App\Models\BillDetail;
use App\Models\SchoolClass;
use App\Models\Student;
use Illuminate\Http\Request;

class BillDetailController extends Controller
{
    public function store(Request $request)
    {
        $result = ['success' => true, 'description' => 'Tagihan Berhasil Di Aplikasikan'];
        parse_str($request->formMonth, $formMonth);
        $result['formMonth'] = $formMonth;
        $isValidate = true;

        foreach ($formMonth as $fieldName => $fieldValue) {
            if (empty($fieldValue)) {
                $isValidate = false;
            }
        }

        if ($isValidate) {
            try {
                $checklists = [];
                $checklistIDS = null;
                // if ($request->ids != null) {
                //     parse_str(urldecode($request->ids), $checklists);
                //     $checklistIDS = $checklists['ids'];
                // }
                // $result['ids'] = $checklistIDS;
                // dd($result['ids']);
                if ($request->ids != null) {
    parse_str(urldecode($request->ids), $checklists);
    
    if (isset($checklists['ids'])) {
        $checklistIDS = array_unique($checklists['ids']); // Hapus duplikat
    } else {
        $checklistIDS = [];
    }
}
$result['ids'] = $checklistIDS;


                $bill = Bill::with('school_year')->findOrFail($request->bill);
                $formAmount = $request->formAmount;
                $formActivedAt = $request->formActivedAt;
                $formMonth = $request->formMonth;
                parse_str($formMonth, $formData);

                switch ($request->application) {
                    case 'semua':
                        $students = Student::whereHas('school_class', function ($query) {
                            $query->whereHas('educational_level', function ($query) {
                                $query->where('institution_id', institution()->id);
                            });
                        })->get();
                        break;
                    case 'jenjang':
                        $students = Student::whereHas('school_class', function ($query) use ($result) {
                            $query->whereIn('educational_level_id', $result['ids']);
                        })->get();
                        break;
                    case 'angkatan':
                        $students = Student::whereHas('school_class', function ($query) use ($result) {
                            $query->whereIn('batch', $result['ids']);
                        })->get();
                        break;
                    case 'kelas':
                        $students = Student::whereHas('school_class', function ($query) use ($result) {
                            $query->whereIn('id', $result['ids']);
                        })->get();
                        break;
                    case 'santri':
                        $students = Student::whereIn('id', $result['ids'])->get();
                        break;
                    default:
                        break;
                }

                if ($students->isEmpty()) {
                    $result['error'] = 'Belum Ada Santri!';
                    $result['success'] = false;
                } else {
                    $this->processStudentBillCreate(
                        $request,
                        $students,
                        $bill,
                        $formAmount,
                        $formActivedAt,
                        $formData
                    );
                }
            } catch (\Throwable $th) {
                //throw $th;
                $result['error'] = $th->getMessage();
                if ($result['error'] == 'Undefined array key "ids"') {
                    $result['error'] = 'Mohon dichecklist table aplikasinya terlebih dahulu!';
                }
                $result['success'] = false;
            }
        } else {
            $result['error'] = 'Nominal Bulanan Harus diisi semua!';
            $result['success'] = false;
        }

        return response()->json($result);
    }

    public function index(Request $request, $id)
    {
        $bill = Bill::findOrFail($id);
        $bulan1 = $request->input('bln1');
        $bulan2 = $request->input('bln2');


        $bill_details = BillDetail::with(['bill', 'student'])
            ->where('bill_id', $id)
            ->where('status', 'BILLED')
            ->when($bulan1 && $bulan2, function ($query) use ($bulan1, $bulan2) {
                return $query->whereBetween('actived_at', [date('Y-m-01', strtotime($bulan1)), date('Y-m-t', strtotime($bulan2))]);
            })
            ->get();


        $school_class = SchoolClass::all();
        $bill_categories = BillCategory::all();
        $totalAmount = $bill_details->sum('amount');
        $categories = $bill->bill_category->name;
        $idBillDetails = 'bill-details-table';
        $headers = [
            '#',
            'NIS',
            'Nama',
            'Kelas',
            'Tertagih',
            'Aktif'
        ];
        $no = 1;
        $rows = [];
        foreach ($bill_details as $bills) {
            $rows[] = [
                $no++,
                $bills->student->nis,
                $bills->student->name,
                $bills->student->school_class->name,
                'Rp. ' . number_format($bills->amount, 0, ',', '.') . ',',
                formatToIndonesianDate($bills->actived_at),
                $bills->student->id,
            ];
        }

        return view('pages.institution.bill.detail.index', compact('bill_details', 'bill', 'idBillDetails', 'headers', 'rows', 'totalAmount', 'categories', 'bulan1', 'bulan2'));
    }

    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {
        //
    }

    public function destroy(Request $request)
    {
        $result = ['success' => true];
        parse_str($request->formMonth, $formMonth);
        $result['formMonth'] = $formMonth;

        try {
            $checklists = [];
            $checklistIDS = null;
            if ($request->ids != null) {
                parse_str(urldecode($request->ids), $checklists);
                $checklistIDS = $checklists['ids'];
            }
            $result['ids'] = $checklistIDS;

            $bill = Bill::with('school_year', 'payments')->findOrFail($request->bill);

            $formMonth = $request->formMonth;
            parse_str($formMonth, $formData);


            switch ($request->application) {
                case 'semua':
                    $students = Student::whereHas('school_class', function ($query) {
                        $query->whereHas('educational_level', function ($query) {
                            $query->where('institution_id', institution()->id);
                        });
                    })->get();
                    break;
                case 'jenjang':
                    $students = Student::whereHas('school_class', function ($query) use ($result) {
                        $query->whereIn('educational_level_id', $result['ids']);
                    })->get();
                    break;
                case 'angkatan':
                    $students = Student::whereHas('school_class', function ($query) use ($result) {
                        $query->whereIn('batch', $result['ids']);
                    })->get();
                    break;
                case 'kelas':
                    $students = Student::whereHas('school_class', function ($query) use ($result) {
                        $query->whereIn('id', $result['ids']);
                    })->get();
                    break;
                case 'santri':
                    $students = Student::whereIn('id', $result['ids'])->get();
                    break;
                default:
                    break;
            }

            if ($bill->payments->isNotEmpty()) {
                $result['error'] = 'Maaf Tagihan Tidak Bisa Dibatalkan!';
                $result['success'] = false;
            } else {
                $this->processStudentBillDelete(
                    $request,
                    $students,
                    $bill,
                    $formData
                );
            }
        } catch (\Throwable $th) {
            //throw $th;
            $result['error'] = $th->getMessage();
            if ($result['error'] == 'Undefined array key "ids"') {
                $result['error'] = 'Mohon dichecklist table aplikasinya terlebih dahulu!';
            } else if ($result['error'] == 'Call to undefined relationship [payments] on model [App\\Models\\Bill].') {
                $result['error'] = 'Tagihan Belum Dibuat!';
            }
            $result['success'] = false;
        }

        return response()->json($result);
    }

    /**
     * Membuat detail tagihan
     *
     */
    private function createBillDetail(
        $billId,
        $studentId,
        $month,
        $activedAt,
        $amount
    ) {
        $row = [
            'bill_id' => $billId,
            'student_id' => $studentId,
            'month' => $month,
            'actived_at' => $activedAt,
            'amount' => preg_replace('/[^0-9]/', '', $amount) ?? 0,
        ];

        return BillDetail::updateOrCreate(
            ['bill_id' => $billId, 'student_id' => $studentId, 'month' => $month],
            $row
        );
    }

    /**
     * Menghapus detail tagihan
     *
     */
    private function deleteBillDetail(
        $billId,
        $studentId,
        $month
    ) {
        return BillDetail::where('bill_id', $billId)
            ->where('student_id', $studentId)
            ->where('month', $month)
            ->delete();
    }

    /**
     * Kalkulasi perhitungan bulan, untuk mendapatkan nama bulan
     * berdasarkan tanggal
     *
     */
    private function calculateMonthKey($i, $schoolYear)
    {
        if ($i < 7) {
            return strtolower(date('F', strtotime("{$i}/1/{$schoolYear->end_year}")));
        } else {
            return strtolower(date('F', strtotime("{$i}/1/{$schoolYear->start_year}")));
        }
    }

    /**
     * Segala proses pembuatan tagihan untuk santri
     *
     */
    private function processStudentBillCreate(
        Request $request,
        $students,
        $bill,
        $formAmount,
        $formActivedAt,
        $formData
    ) {
        foreach ($students as $student) {
            if ($request->category == 'Bulanan') {
                for ($i = 1; $i <= 12; $i++) {
                    $monthKey = $this->calculateMonthKey($i, $bill->school_year);
                    $activedAt = ($i < 7) ? $bill->school_year->end_year . '-0' . $i . '-01' : $bill->school_year->start_year . '-0' . $i . '-01';
                    $this->createBillDetail($request->bill, $student->id, $i, $activedAt, $formData[$monthKey]);
                }
            } else {
                $this->createBillDetail($request->bill, $student->id, null, $formActivedAt, $formAmount);
            }
        }
    }

    /**
     * Segala proses penghapusan tagihan untuk santri
     *
     */
    private function processStudentBillDelete(
        Request $request,
        $students,
        $bill,
        $formData
    ) {
        foreach ($students as $student) {
            if ($request->category == 'Bulanan') {
                for ($i = 1; $i <= 12; $i++) {
                    $monthKey = $this->calculateMonthKey($i, $bill->school_year);
                    $this->deleteBillDetail($request->bill, $student->id, $i, $formData[$monthKey]);
                }
            } else {
                $this->deleteBillDetail($request->bill, $student->id, null);
            }
        }
    }
}
