<?php

namespace App\Http\Controllers\Config;

use App\Http\Controllers\Controller;
use App\Models\ApiToken;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class ApiTokenController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->only(['name']);
        $originalName = $data['name'];
        $notif = ['status' => 'notif-success', 'description' => 'Berhasil menambahkan data!'];
        $key = Str::random(64);

        $notif = insertBasicTableFormatted(new ApiToken, [
            'name' => $data['name'],
            'access_token' => $key,
            'refresh_token' => '',
        ], $notif, $originalName);

        return redirect()->route('config')->with($notif['status'], $notif['description']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $apiToken = ApiToken::where('id', $id)->first();

        return response()->json($apiToken);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // dd($request);
        $data = $request->only(['name']);
        $originalName = $data['name'];
        $notif = ['status' => 'notif-success', 'description' => 'Berhasil update data!'];

        $notif = updateBasicTableFormatted(new ApiToken, $id, [
            'name' => $data['name'],
        ], $notif, $originalName);

        return redirect()->back()->with($notif['status'], $notif['description']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $notif = ['status' => 'notif-success', 'success' => true, 'description' => 'Berhasil menghapus data!'];
        $id = empty($request->ids) || !isset($request->ids) ? $request->id_confirm : $request->ids;

        $notif = deleteBasicTableFormatted(new ApiToken, $id, $notif);

        return response()->json($notif);
    }
}
