<?php

namespace App\Http\Controllers\Config;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\ApiToken;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class ConfigController extends Controller
{
    public function index()
    {
        $apiTokens = ApiToken::all();
        $idApiTokenTable = 'api-token-table';
        $headers = [
            '#',
            'Nama Aplikasi',
            'Access Token',
            'Copy',
        ];
        $rows = [
            // [
            //     1,
            //     '201200001',
            //     'ABDULLAH AL-ARIF',
            //     'SMP/MTs',
            //     '7-A',
            // ]
        ];

        $no = 1;
        foreach ($apiTokens as $apiToken) {
            $rows[] = [
                $no++,
                $apiToken->name,
                $apiToken->access_token,
                ' <button type="button" class="clipboard-btn btn btn-warning mx-2" data-clipboard-action="copy" data-clipboard-text="' . $apiToken->access_token . '">
                Copy
              </button>',
                $apiToken->id,
            ];
        }

        return view('pages.admin.config.index', compact('idApiTokenTable', 'headers', 'rows'));
    }

    public function store(Request $request)
    {
        $file = $request->file('restore_file');

        if (!$file->isValid()) {
            return "GAGAL UPLOAD<br>" . $file->getError();
        }

        $filePath = $file->store('restore', 'public');

        $fileContent = file_get_contents(public_path('storage/' . $filePath));

        $fileContent = preg_replace('/DELIMITER.*?DELIMITER ;/ms', '', $fileContent);

        $queries = explode(';', $fileContent);
        // dd($queries);
        try {
            DB::beginTransaction();

            // menghapus semua table hingga tersisa migrations
            Artisan::call('migrate:reset');
            // menghapus table migrations
            Schema::dropIfExists('migrations');
            foreach ($queries as $query) {
                $query = trim($query);
                if (!empty($query)) {
                    DB::statement($query);
                }
            }

            DB::commit();

            session()->flash('notif-success', 'Data Berhasil Diedit');
            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollBack();
            // throw $e;
            session()->flash('notif-error', 'Data Gagal Diedit');
            return redirect()->back();
        } finally {
            unlink(public_path('storage/' . $filePath));
        }
    }
}
