<?php

namespace App\Http\Controllers\Dashboard;

use App\Http\Controllers\Controller;
use App\Models\Institution;
use App\Models\Payment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Carbon\Carbon;


class DashboardController extends Controller
{

    public function index()
    {
        $institutionCount = Institution::count();
        $paymentsToday = Payment::selectRaw('DATE(created_at) as date, COUNT(id) as total')
            ->groupBy('date')
            ->get()
            ->pluck('total', 'date');
        $paymentsMonth = Payment::selectRaw('YEAR(created_at) as year, MONTH(created_at) as month,COUNT(id) as total')
            ->groupBy('year', 'month')
            ->get()
            ->mapWithKeys(function ($value) {
                return [Carbon::create($value->year, $value->month)->format('Y-m') => $value->total];
            })
            ->toArray();
        $paymentsPerDay = Payment::selectRaw('DATE(created_at) as date, SUM(amount) as total_amount')
            ->groupBy('date')
            ->get()
            ->pluck('total_amount', 'date');
        $paymentsPerMonth = Payment::selectRaw('YEAR(created_at) as year, MONTH(created_at) as month, SUM(amount) as total_amount')
            ->groupBy('year', 'month')
            ->get()
            ->mapWithKeys(function ($value) {
                return [Carbon::create($value->year, $value->month)->format('Y-m') => $value->total_amount];
            })
            ->toArray();
        // $now = Carbon::now();
        // $lastDataTimestamp = null;
        // $lastDataTimestamp = Payment::where('created_at', '>=', $now->subMinutes(1))->orderBy('created_at', 'desc')->first();

        // if (!$lastDataTimestamp) {
        //     $lastDataTimestamp = Payment::where('created_at', '>=', $now->subHours(1))->orderBy('created_at', 'desc')->first();
        // }

        // if (!$lastDataTimestamp) {
        //     $lastDataTimestamp = Payment::where('created_at', '>=', $now->subDays(1))->orderBy('created_at', 'desc')->first();
        // }

        // if (!$lastDataTimestamp) {
        //     $lastDataTimestamp = Payment::where('created_at', '>=', $now->subDays(5))->orderBy('created_at', 'desc')->first();
        // }

        // if ($lastDataTimestamp) {
        //     $lastDataTimestampText = Carbon::parse($lastDataTimestamp->created_at)->diffForHumans();
        // } else {
        //     $lastDataTimestampText = 'Tidak Ada Transaksi 5 Hari Terakhir';
        // }



        // $currentMonth = Carbon::now()->format('Y-m');
        // $oneMonthAgo = Carbon::now()->subMonths(1)->format('Y-m');

        // if (!array_key_exists($currentMonth, $paymentsPerMonth)) {
        //     $lastDataTimestampText = 'Tidak Ada Transaksi 1 Bulan Terakhir';
        // }

        if (request()->fullUrlIs(route('admin'))) {
            return view('pages.admin.index', compact('institutionCount', 'paymentsToday', 'paymentsMonth'));
        } else if (request()->fullUrlIs(route('institution'))) {
            return view('pages.institution.index', compact('paymentsPerDay', 'paymentsPerMonth', 'paymentsToday'));
        } else {
            return redirect('/');
        }
    }
}
