<?php

namespace App\Http\Controllers\EduLevel;

use App\Http\Controllers\Controller;
use App\Models\EducationalLevel;
use App\Models\Institution;
use Illuminate\Http\Request;

class EduLevelController extends Controller
{
    public function index()
    {
        // dd(auth()->user()->institution->id);
        $eduLevels = EducationalLevel::where('institution_id', institution()->id)->get();
        $idEduLevelTable = 'edu-level-table';
        $headers = [
            '#',
            'Jenjang',
        ];
        $rows = [];
        $no = 1;
        foreach ($eduLevels as $eduLevel) {
            $rows[] = [
                $no++,
                $eduLevel->name,
                $eduLevel->id,
            ];
        }

        return view('pages.institution.manage-data.edulevel.index', compact('idEduLevelTable', 'headers', 'rows'));
    }

    public function edit($id)
    {
        $schoolClass = EducationalLevel::where('id', $id)->first();

        return response()->json($schoolClass);
    }

    public function store(Request $request)
    {
        $data = $request->only(['name']);
        $data['institution_id'] = auth()->user()->institution->id;
        $originalName = $data['name'];
        $notif = ['status' => 'notif-success', 'description' => 'Berhasil menambahkan data!'];

        $notif = insertBasicTableFormatted(new EducationalLevel, [
            'name' => $data['name'],
            'institution_id' => $data['institution_id'],
        ], $notif, $originalName);

        return redirect()->route('institution.edulevel')->with($notif['status'], $notif['description']);
    }

    public function update(Request $request, $id)
    {
        $data = $request->only(['name']);
        $data['institution_id'] = auth()->user()->institution->id;
        $originalName = $data['name'];
        $notif = ['status' => 'notif-success', 'description' => 'Berhasil update data!'];

        $notif = updateBasicTableFormatted(new EducationalLevel, $id, [
            'name' => $data['name'],
            'institution_id' => $data['institution_id'],
        ], $notif, $originalName);

        return redirect()->route('institution.edulevel')->with($notif['status'], $notif['description']);
    }

    public function destroy(Request $request)
    {
        $notif = ['status' => 'notif-success', 'success' => true, 'description' => 'Berhasil menghapus data!'];
        $id = empty($request->ids) || !isset($request->ids) ? $request->id_confirm : $request->ids;

        $notif = \deleteBasicTableFormatted(new EducationalLevel, $id, $notif);

        return response()->json($notif);
    }
}
