<?php

namespace App\Http\Controllers\Finance;

use App\Exports\ExportBill;
use App\Exports\ExportDay;
use App\Exports\ExportMonth;
use App\Http\Controllers\Controller;
use App\Models\Bill;
use App\Models\SchoolYear;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use Carbon\Carbon;

class FinanceController extends Controller
{
    public function index()
    {
        $tp = SchoolYear::all();
        $billList =  Bill::all();
        return view('pages.institution.report.finance.index', compact('tp', 'billList'));
    }

  public function getTrxDay(Request $request)
{
    $tglAwal = $request->input('tgl_awal');
    $tglAkhir = $request->input('tgl_akhir');

    $paidBills = DB::table('bill_details as bd')
        ->leftJoin('bills as b', 'bd.bill_id', '=', 'b.id')
        ->join('payments as p', 'bd.id', '=', 'p.bill_detail_id')
        ->join('students as s', 'bd.student_id', '=', 's.id')
        ->leftJoin('school_years as sy', 'b.school_year_id', '=', 'sy.id')
        ->where('bd.status', 'PAID')
        ->where('b.institution_id', institution()->id)
        ->whereDate('bd.updated_at', '>=', $tglAwal)
        ->whereDate('bd.updated_at', '<=', $tglAkhir)
        ->groupBy('bd.id', 's.name', 'b.name', 'bd.month', 'bd.amount', 'bd.updated_at', 'bd.actived_at')
        ->select(
            'bd.id', 
            's.name as nama_santri', 
            'b.name as deskripsi', 
            'bd.month as bulan', 
            'bd.amount as nominal', 
            'bd.updated_at as tanggal', 
            DB::raw('MONTH(bd.actived_at) as bulan_aktif'), 
            DB::raw('YEAR(bd.actived_at) as tahun_aktif')
        )
        ->get();

    return response()->json($paidBills);
}
    public function getTrxMonth(Request $request)
    {
        $bulan = $request->input('bulan');
        $tp = $request->input('tp');

        $paidBills = DB::table('bill_details as bd')
            ->leftJoin('bills as b', 'b.id', '=', 'bd.bill_id')
            ->join('payments as p', 'bd.id', '=', 'p.bill_detail_id')
            ->join('students as s', 's.id', '=', 'bd.student_id')
            ->leftJoin('school_years as sy', 'sy.id', '=', 'b.school_year_id')
            ->where('bd.status', 'PAID')
            ->where('b.institution_id', institution()->id)
            ->whereMonth('bd.updated_at', $bulan)
            ->where('sy.id', $tp)
            ->groupBy('bd.id', 's.name', 'b.name', 'bd.amount', 'bd.updated_at',  'bd.actived_at')
            ->select('bd.id', 's.name as nama_santri', 'b.name as deskripsi', 'bd.amount as nominal', 'bd.updated_at as tanggal', DB::raw('MONTH(bd.actived_at) as bulan_aktif'), DB::raw('YEAR(bd.actived_at) as tahun_aktif'))
            ->get();


        return response()->json($paidBills);
    }
    // public function getTrxBill(Request $request)
    // {
    //     $tagihan = $request->input('tagihan');
    //     $status = $request->input('status');
    //     $paidBills = DB::table('bill_details as bd')
    //         ->leftJoin('bills as b', 'b.id', '=', 'bd.bill_id')
    //         ->leftJoin('payments as p', 'bd.id', '=', 'p.bill_detail_id')
    //         ->join('students as s', 's.id', '=', 'bd.student_id')
    //         ->leftJoin('school_years as sy', 'sy.id', '=', 'b.school_year_id')
    //         ->where('bd.status', $status)
    //         ->where('b.institution_id', institution()->id)
    //         ->where('b.name', $tagihan)
    //         ->groupBy('bd.id', 's.name', 'b.name', 'bd.amount', 'bd.updated_at',  'bd.actived_at', 'bd.status')
    //         ->select('bd.id', 'bd.status', 's.name as nama_santri', 'b.name as deskripsi', 'bd.amount as nominal', 'bd.updated_at as tanggal',  DB::raw('MONTH(bd.actived_at) as bulan_aktif'), DB::raw('YEAR(bd.actived_at) as tahun_aktif'))
    //         ->get();


    //     return response()->json($paidBills);
    // }
    public function getTrxBill(Request $request)
    {
        $tagihan = $request->input('tagihan');
        $status = $request->input('status');
        $tglAktifAwal = $request->input('tgl_aktif_awal');
        $tglAktifAkhir = $request->input('tgl_aktif_akhir');

        $query = DB::table('bill_details as bd')
            ->leftJoin('bills as b', 'b.id', '=', 'bd.bill_id')
            ->leftJoin('bill_categories as bc', 'b.bill_category_id', '=', 'bc.id')
            ->leftJoin('payments as p', 'bd.id', '=', 'p.bill_detail_id')
            ->join('students as s', 's.id', '=', 'bd.student_id')
            ->leftJoin('school_years as sy', 'sy.id', '=', 'b.school_year_id')
            ->where('b.institution_id', institution()->id)
            ->where('b.name', $tagihan);

        if ($status !== 'ALL') {
            $query->where('bd.status', $status);
        }

        // Filter berdasarkan rentang tanggal aktif
        if ($tglAktifAwal && $tglAktifAkhir) {
            $query->whereBetween(DB::raw('DATE(bd.actived_at)'), [$tglAktifAwal, $tglAktifAkhir]);
        }

        $bills = $query
            ->groupBy('bd.id', 's.name', 'b.name', 'bd.amount', 'bd.updated_at', 'bd.actived_at', 'bd.status')
            ->select(
                'bd.id',
                'bd.status',
                's.name as nama_santri',
                'b.name as deskripsi',
                'bd.amount as nominal',
                'bd.updated_at as tanggal',
                'bd.actived_at'
            )
            ->get();

        return response()->json($bills);
    }

    public function exportBill(Request $request)
    {
        $tagihan = $request->input('tagihan');
        $status = $request->input('status');
        $tglAktifAwal = $request->input('tgl_aktif_awal');
        $tglAktifAkhir = $request->input('tgl_aktif_akhir');
        $institution = $request->input('institution');
        
        return Excel::download(new ExportBill($tagihan, $status, $tglAktifAwal, $tglAktifAkhir, $institution), 'laporan-tagihan.xlsx');
    }
    public function exportMonth(Request $request)
    {
        $tp = $request->input('tp');
        $bulan = $request->input('bulan');
        $institution = $request->input('institution');
        return Excel::download(new ExportMonth($tp, $bulan, $institution), 'laporan-tagihan.xlsx');
    }
    public function exportDay(Request $request)
    {
        $tgl_awal = $request->input('tgl_awal');
        $tgl_akhir = $request->input('tgl_akhir');
        $institution = $request->input('institution');
        return Excel::download(new ExportDay($tgl_awal, $tgl_akhir, $institution), 'laporan-tagihan.xlsx');
    }

    public function getDashboardData()
    {
        $currentMonth = Carbon::now();
        $previousMonth = Carbon::now()->subMonth();

        // Data bulan ini
        $paymentsToday = BillDetail::join('payments', 'bill_details.id', '=', 'payments.bill_detail_id')
            ->where('bill_details.status', 'PAID')
            ->whereMonth('bill_details.updated_at', $currentMonth->month)
            ->whereYear('bill_details.updated_at', $currentMonth->year)
            ->selectRaw('DATE(bill_details.updated_at) as date, SUM(amount) as total')
            ->groupBy('date')
            ->get()
            ->pluck('total', 'date')
            ->toArray();

        // Data bulan sebelumnya
        $previousMonthData = BillDetail::join('payments', 'bill_details.id', '=', 'payments.bill_detail_id')
            ->where('bill_details.status', 'PAID')
            ->whereMonth('bill_details.updated_at', $previousMonth->month)
            ->whereYear('bill_details.updated_at', $previousMonth->year)
            ->selectRaw('DATE(bill_details.updated_at) as date, SUM(amount) as total')
            ->groupBy('date')
            ->get()
            ->pluck('total', 'date')
            ->toArray();

        // Hitung persentase perubahan
        $currentMonthTotal = array_sum($paymentsToday);
        $previousMonthTotal = array_sum($previousMonthData);
        
        $percentageChange = 0;
        if ($previousMonthTotal > 0) {
            $percentageChange = (($currentMonthTotal - $previousMonthTotal) / $previousMonthTotal) * 100;
        }

        return view('pages.dashboard', compact('paymentsToday', 'previousMonthData', 'percentageChange'));
    }
}
