<?php

namespace App\Http\Controllers\SchoolClass;

use App\Http\Controllers\Controller;
use App\Models\EducationalLevel;
use App\Models\SchoolClass;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class SchoolClassController extends Controller
{
    public function index()
    {
        $schoolClasses = SchoolClass::latest()->whereHas('educational_level', function ($query) {
            $query->where('institution_id', institution()->id);
        })->get();
        $eduLevels = EducationalLevel::where('institution_id', institution()->id)->get();
        $idSchoolClassTable = 'school-class-table';
        $headers = [
            'Kelas',
            'Angkatan',
            'Jenjang',
            'Kode'
        ];
        $rows = [];
        $no = 1;
        foreach ($schoolClasses as $schoolClass) {
            $rows[] = [
                $schoolClass->name,
                $schoolClass->batch,
                $schoolClass->educational_level->name,
                $schoolClass->code,
                $schoolClass->id,
            ];
        }
        return view('pages.institution.manage-data.school-class.index', compact(
            'eduLevels',
            'idSchoolClassTable',
            'headers',
            'rows'
        ));
    }

    public function create()
    {
        $eduLevels = EducationalLevel::where('institution_id', institution()->id)->get();

        return view('pages.institution.manage-data.school-class.create', compact('eduLevels'));
    }

    public function edit($id)
    {
        $schoolClass = SchoolClass::where('id', $id)->first();

        return response()->json($schoolClass);
    }

    public function store(Request $request)
    {
        $data = $request->only(['name', 'batch', 'eduLevel']);
        $originalName = $data['name'];
        $notif = ['status' => 'notif-success', 'success' => true, 'description' => 'Berhasil menambahkan data!'];

        if ($request->ajax()) {

            $dataSets = array_map(function ($batch, $eduLevel, $name) {
                return [
                    'batch' => $batch,
                    'eduLevel' => $eduLevel,
                    'name' => $name
                ];
            }, $data['batch'], $data['eduLevel'], $data['name']);

            // Menghapus elemen yang memiliki value null
            $dataSets = array_filter($dataSets, function ($item) {
                return $item['batch'] !== null && $item['eduLevel'] !== null && $item['name'] !== null;
            });

            if (!empty($dataSets)) {
                $notifs = [];

                foreach ($dataSets as $dataSet) {
                    $originalName = $dataSet['name'];
                    $notifs[] = insertBasicTableFormatted(new SchoolClass, [
                        'name' => $dataSet['name'],
                        'batch' => $dataSet['batch'],
                        'code' => Str::random(10),
                        'educational_level_id' => $dataSet['eduLevel'],
                    ], $notif, $originalName);
                }

                foreach ($notifs as $data) {
                    if (!$data['success']) {
                        $notif = $data;
                    }
                }
            } else {
                $notif['status'] = 'notif-error';
                $notif['success'] = false;
                $notif['description'] = 'Tidak ada data masuk!';
            }

            return response()->json($notif);
        }

        $notif = insertBasicTableFormatted(new SchoolClass, [
            'name' => $data['name'],
            'batch' => $data['batch'],
            'code' => Str::random(10),
            'educational_level_id' => $data['eduLevel'],
        ], $notif, $originalName);

        return redirect()->route('institution.class')->with($notif['status'], $notif['description']);
    }

    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'batch', 'eduLevel']);
        $originalName = $data['name'];
        $notif = ['status' => 'notif-success', 'description' => 'Berhasil update data!'];

        $notif = updateBasicTableFormatted(new SchoolClass, $id, [
            'name' => $data['name'],
            'batch' => $data['batch'],
            'educational_level_id' => $data['eduLevel'],
        ], $notif, $originalName);

        return redirect()->route('institution.class')->with($notif['status'], $notif['description']);
    }

    public function destroy(Request $request)
    {
        $notif = ['status' => 'notif-success', 'success' => true, 'description' => 'Berhasil menghapus data!'];
        $id = empty($request->ids) || !isset($request->ids) ? $request->id_confirm : $request->ids;

        $notif = \deleteBasicTableFormatted(new SchoolClass, $id, $notif);

        return response()->json($notif);
    }
}
