<?php

namespace App\Http\Controllers\SchoolYear;

use App\Http\Controllers\Controller;
use App\Models\SchoolYear;
use Illuminate\Http\Request;

class SchoolYearController extends Controller
{
    public function index()
    {
        $schoolYears = SchoolYear::all();
        $idSchoolYearTable = 'school-year-table';
        $headers = [
            '#',
            'Tahun Mulai',
            'Tahun Akhir',
        ];
        $rows = [];
        $no = 1;
        foreach ($schoolYears as $schoolYear) {
            $rows[] = [
                $no++,
                $schoolYear->start_year,
                $schoolYear->end_year,
                $schoolYear->id,
            ];
        }
        return view('pages.institution.manage-data.school-years.index', compact('idSchoolYearTable', 'headers', 'rows'));
    }

    public function edit($id)
    {
        $schoolYear = SchoolYear::where('id', $id)->first();

        return response()->json($schoolYear);
    }

    public function store(Request $request)
    {
        $data = $request->only(['start_year', 'end_year']);
        // $originalName = $data['name'];
        $notif = ['status' => 'notif-success', 'description' => 'Berhasil menambahkan data!'];

        $notif = insertBasicTableFormatted(new SchoolYear, [
            'start_year' => $data['start_year'],
            'end_year' => $data['end_year'],
        ], $notif);

        return redirect()->route('institution.school-year')->with($notif['status'], $notif['description']);
    }

    public function update(Request $request, $id)
    {
        $data = $request->only(['start_year', 'end_year']);
        // $originalName = $data['name'];
        $notif = ['status' => 'notif-success', 'description' => 'Berhasil update data!'];

        $notif = updateBasicTableFormatted(new SchoolYear, $id, [
            'start_year' => $data['start_year'],
            'end_year' => $data['end_year'],
        ], $notif);

        return redirect()->route('institution.school-year')->with($notif['status'], $notif['description']);
    }

    public function destroy(Request $request)
    {
        $notif = ['status' => 'notif-success', 'success' => true, 'description' => 'Berhasil menghapus data!'];
        $id = empty($request->ids) || !isset($request->ids) ? $request->id_confirm : $request->ids;

        $notif = \deleteBasicTableFormatted(new SchoolYear, $id, $notif);

        return response()->json($notif);
    }
}
