<?php

namespace App\Http\Controllers\Student;

use App\Exports\StudentExport;
use App\Exports\StudentImportFormat;
use App\Http\Controllers\Controller;
use App\Imports\StudentImport;
use App\Models\Bill;
use App\Models\BillDetail;
use App\Models\EducationalLevel;
use App\Models\SchoolClass;
use App\Models\Student;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class StudentController extends Controller
{
    public function index()
    {
        $students = Student::whereHas('school_class', function ($query) {
            $query->whereHas('educational_level', function ($query) {
                $query->where('institution_id', institution()->id);
            });
        })->get();
        $school_classes = SchoolClass::whereHas('educational_level', function ($query) {
            $query->where('institution_id', institution()->id);
        })->get();
        $educational_levels = EducationalLevel::with('schoolClasses')
            ->where('institution_id', institution()->id)
            ->get();
        $idStudentTable = 'student-table';
        $headers = [
            '#',
            'Nis',
            'Nama',
            'Jenjang',
            'Kelas',
        ];
        $rows = [
            // [
            //     1,
            //     '201200001',
            //     'ABDULLAH AL-ARIF',
            //     'SMP/MTs',
            //     '7-A',
            // ]
        ];

        $no = 1;
        foreach ($students as $student) {
            $rows[] = [
                $no++,
                $student->nis,
                $student->name,
                $student->school_class->educational_level->name,
                $student->school_class->name,
                $student->id,
            ];
        }

        return view('pages.institution.manage-data.student.index', compact('school_classes', 'idStudentTable', 'headers', 'rows', 'educational_levels'));
    }

    public function show($id)
    {
        $student = Student::with('school_class.educational_level.institution')
            ->where('id', $id)
            ->first();
        $school_classes = SchoolClass::whereHas('educational_level', function ($query) {
            $query->where('institution_id', institution()->id);
        })->get();
        $bill_details = BillDetail::where('student_id', $student->id)
            // ->whereYear('actived_at', '<=', now()->year)
            // ->whereMonth('actived_at', '<=', now()->month)
            ->get();

        // dd(['tahun' => now()->year, 'bulan' => now()->month]);
        // dd(['tahun' => now()->year, 'bulan' => now()->month]);
        $billed = BillDetail::where('student_id', $student->id)
            // ->whereYear('actived_at', '<=', now()->year)
            // ->whereMonth('actived_at', '<=', now()->month)
            ->where('status', 'BILLED')->sum('amount');
        $paid = BillDetail::where('student_id', $student->id)
            // ->whereYear('actived_at', '<=', now()->year)
            // ->whereMonth('actived_at', '<=', now()->month)
            ->where('status', 'PAID')->sum('amount');

        $groupedBillDetails = $bill_details->groupBy('bill_id');

        return view('pages.institution.manage-data.student.show', compact(
            'student',
            'groupedBillDetails',
            'school_classes',
            'billed',
            'paid'
        ));
    }


    public function edit($id)
    {
        $student = Student::where('id', $id)->first();

        return response()->json($student);
    }

    public function store(Request $request)
    {
        $data = $request->only(['name', 'nis', 'school_class', 'phone']);
        $originalName = $data['name'];
        $notif = ['status' => 'notif-success', 'success' => true, 'description' => 'Berhasil menambahkan data!'];

        $notif = insertBasicTableFormatted(new Student, [
            'nis' => $data['nis'],
            'name' => $data['name'],
            'school_class_id' => $data['school_class'],
            'phone' => $data['phone'],
        ], $notif, $originalName);

        return redirect()->route('institution.student')->with($notif['status'], $notif['description']);
    }

    public function update(Request $request, $id)
    {
        // dd($request);
        $data = $request->only(['name', 'nis', 'school_class', 'phone']);
        $originalName = $data['name'];
        $notif = ['status' => 'notif-success', 'success' => true, 'description' => 'Berhasil update data!'];

        $notif = updateBasicTableFormatted(new Student, $id, [
            'nis' => $data['nis'],
            'name' => $data['name'],
            'school_class_id' => $data['school_class'],
            'phone' => $data['phone'],
        ], $notif, $originalName);

        return redirect()->back()->with($notif['status'], $notif['description']);
    }

    public function updateBill(Request $request)
    {
        $notif = ['status' => 'notif-success', 'success' => true, 'description' => 'Berhasil update data!'];
        $data = $request->only(['student_id', 'bill_id']);
        try {
            BillDetail::where('student_id', $data['student_id'])
                ->where('bill_id', $data['bill_id'])
                ->update(['status' => 'PAID']);
        } catch (\Throwable $th) {
            //throw $th;
            $notif['status'] = 'notif-error';
            $notif['description'] = 'Gagal update data!';
        }

        return redirect()->route('institution.student.show', $request->student_id)->with($notif['status'], $notif['description']);
    }

    public function updateBillWithAjax(Request $request)
    {
        $notif = ['status' => 'notif-success', 'success' => true, 'description' => 'Berhasil update data!'];
        $data = $request->only(['student_id', 'ids']);
        $ids = $data['ids'];
        $notif['data'] = $data;
        try {
            if ($ids['0'] == 'on') {
                \array_shift($ids);
            }
            foreach ($ids as $id) {
                $bill_detail = BillDetail::where('id', $id)->first();
                BillDetail::where('student_id', $data['student_id'])
                    ->where('bill_id', $bill_detail->bill_id)
                    ->update(['status' => 'PAID']);
            }
        } catch (\Throwable $th) {
            //throw $th;
            $notif['status'] = 'notif-error';
            $notif['description'] = 'Gagal update data!';
            $notif['success'] = false;
        }

        return response()->json($notif);
    }

    public function destroy(Request $request)
    {
        $notif = ['status' => 'notif-success', 'success' => true, 'description' => 'Berhasil menghapus data!'];
        $id = empty($request->ids) || !isset($request->ids) ? $request->id_confirm : $request->ids;

        $notif = deleteBasicTableFormatted(new Student, $id, $notif);

        return response()->json($notif);
    }

    public function import(Request $request)
    {
        $file = $request->file('santri_file')->store('public/import');

        $import = new StudentImport;

        try {
            Excel::import($import, $file, null, \Maatwebsite\Excel\Excel::XLSX);
        } catch (\Maatwebsite\Excel\Validators\ValidationException $e) {
            $failures = $e->failures();
            return back()->with('failures', $failures);
        }
        return redirect()->back()->with('notif-success', 'Data berhasil diimport!!');
    }

    public function export()
    {
        return Excel::download(new StudentExport, 'Santri.xlsx', \Maatwebsite\Excel\Excel::XLSX);
    }

    public function importFormat()
    {
        return Excel::download(new StudentImportFormat, 'Santri-Format..xlsx', \Maatwebsite\Excel\Excel::XLSX);
    }
}
