<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $users = User::all();
        $idUserTable = 'user-table';
        $headers = [
            'name',
            'email',
            'role',
        ];
        $rows = [];

        foreach ($users as $user) {
            $rows[] = [
                $user->name,
                $user->email,
                $user->role,
            ];
        }

        return view('pages.user.index', compact('users', 'idUserTable', 'headers', 'rows'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->only(['name', 'username', 'email', 'password', 'role']);
        $notif = ['status' => 'notif-success', 'description' => 'Berhasil menambahkan data!'];

        $notif = $this->insertBasicTableFormatted(new User, [
            'name' => $data['name'],
            'username' => $data['username'],
            'email' => $data['email'],
            'password' => bcrypt($data['password']),
            'status' => 'ACTIVE', // Ubah dari string kosong ke 'ACTIVE'
            'role' => 'INSTITUTION', // Set role secara eksplisit ke 'INSTITUTION',
            'institution_id' => institution()->id
        ], $notif);

        return redirect()->route('user')->with($notif['status'], $notif['description']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = User::where('id', $id)->first();

        return response()->json($user);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'username', 'email', 'password', 'role']);
        $notif = ['status' => 'notif-success', 'description' => 'Berhasil update data!'];

        $notif = $this->updateBasicTableFormatted(new User, $id, [
            'name' => $data['name'],
            'username' => $data['username'],
            'email' => $data['email'],
            'password' => bcrypt($data['password']),
            // 'role' => $data['role'],
            'role' => auth()->user()->role,
        ], $notif);

        return redirect()->route('user')->with($notif['status'], $notif['description']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $notif = ['status' => 'notif-success', 'success' => true, 'description' => 'Berhasil menghapus data!'];
        $id = empty($request->ids) || !isset($request->ids) ? $request->id_confirm : $request->ids;

        $notif = $this->deleteBasicTableFormatted(new User, $id, $notif);

        return response()->json($notif);
    }
}
