<?php

namespace App\Http\Controllers\settlement;

use App\Http\Controllers\Controller;
use App\Models\SchoolYear;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class SettlementController extends Controller
{
    public function index()
    {
        $santri = $this->getSantriDataFromIB();
        $cabang = $santri['cabang'];
        $idNasabah = $santri['id_user'];
        $data = [
            'dataSantri' => $this->getSantriDataFromIB(),
            'tahunPelajaran' => SchoolYear::all(),
            'cek' => $this->getPendingRequest($cabang, $idNasabah)

        ];
        return view('pages.institution.settlement.index', $data);
    }
    private function getSantriDataFromIB()
    {
        $nis = institution()->bank_account_number;
        
       
        $apiUrlSantri = 'https://ib.bsn.co.id/ApiSantri/index/' . $nis;

        $responseSantri = Http::get($apiUrlSantri);
        $data = $responseSantri->json();

        $dataArray = [
            'saldo' => $data['session']['saldo'],
            'idnasabah' => $data['session']['id'],
            'id_user' => $data['session']['id_user'],
            'cabang' => $data['session']['cabang']
        ];

        return $dataArray;
    }

    public function saveToBIZ(Request $request)
    {
        $apiUrl = 'https://biz.bsn.co.id/apisettlement';

        $data = [
            'nama_bank' => $request->nama_bank,
            'no_rek' => $request->no_rek,
            'nama_pemilik' => $request->nama_pemilik,
            'nominal' => $request->nominal,
            'id_user' => $request->id_user,
        ];

        $response = Http::post($apiUrl, $data);

        if ($response->successful()) {
            return redirect()->back()->with('message', 'Data Berhasil Disimpan');
        } else {
            return redirect()->back()->with('error', 'Gagal menyimpan data ke API');
        }
    }

    private function getPendingRequest($cabang, $idNasabah)
    {
        $response = Http::get('https://biz.bsn.co.id/cekPending/', [
            'cabang' => $cabang,
            'id_nasabah' => $idNasabah,
        ]);

        $data = $response->json();
        return $data;
    }

    public function trxSettlementEdu(Request $request)
    {
        $cabang = $request->query('cabang');
        $idnasabah = $request->query('id_nasabah');
        $response = Http::get("https://biz.bsn.co.id/merchant/trxSettlementEdu/?cabang={$cabang}&id_nasabah={$idnasabah}");

        $data = $response->json();
        return $data;
    }
}
