<?php

namespace App\Http\Requests;

use App\Models\Institution;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class InstitutionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = null;
        $user_id = null;
        if (isset($this->id)) {
            $institution = Institution::findOrFail($this->id);
            $id = $institution->id;
            $user_id = $institution->user_id;
        }

        return [
            'name' => ['required', Rule::unique('institutions', 'name')->ignore($id)],
            'institution' => ['required', Rule::unique('institutions', 'institution')->ignore($id)],
            'bank_account_number' => ['required', Rule::unique('institutions', 'bank_account_number')->ignore($id)],
            'bank_account_holder_name' => ['required', Rule::unique('institutions', 'bank_account_holder_name')->ignore($id)],
            'email' => ['required', Rule::unique('institutions', 'email')->ignore($id)],
            'admin_name' => ['required'],
            'admin_username' => ['required', Rule::unique('users', 'username')->ignore($user_id)],
            'admin_email' => ['required', 'email:dns', Rule::unique('users', 'email')->ignore($user_id)],
            'admin_pass' => Rule::requiredIf(!isset($this->id)),
        ];
    }
}
