<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class InstitutionUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => ['required'],
            'institution' => ['required'],
            'bank_account_number' => ['required'],
            'bank_account_holder_name' => ['required'],
            'email' => ['required'],
            'admin_name' => ['required'],
            'admin_username' => ['required'],
            'admin_email' => ['required', 'email:dns'],
        ];
    }
}
