<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Bill extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    public function bill_category()
    {
        return $this->belongsTo(BillCategory::class);
    }

    public function bill_detail()
    {
        return $this->hasMany(BillDetail::class);
    }

    public function school_year()
    {
        return $this->belongsTo(SchoolYear::class);
    }

    public function institution()
    {
        return $this->belongsTo(Institution::class);
    }
}
