<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SchoolClass extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    public function educational_level()
    {
        return $this->belongsTo(EducationalLevel::class);
    }

    public function students()
    {
        return $this->hasMany(Student::class);
    }
    public function educationalLevel()
    {
        return $this->belongsTo(EducationalLevel::class, 'educational_level_id');
    }
}
