<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Student extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    public function school_class()
    {
        return $this->belongsTo(SchoolClass::class);
    }

    public function bill_details()
    {
        return $this->hasMany(BillDetail::class);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }
     public function schoolClass()
    {
        return $this->belongsTo(SchoolClass::class, 'school_class_id');
    }
}
