<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $rules = [
        'email' => ['unique:users'],
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'username', 'password', 'status', 'role', 'phone','institution_id'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /**
     * Configure photo profile for user
     */
    public function getProfileAttribute()
    {
        $options = [
            'name' => $this->name,
            'background' => '137a61',
            'color' => 'fff',
            'size' => 512,
        ];

        return 'https://ui-avatars.com/api/?' . http_build_query($options);
    }

    public function institution()
    {
        return $this->hasOne(Institution::class);
    }
}
