<?php

namespace Services;

use App\Models\SchoolYear;
use App\Models\EducationalLevel;
use App\Models\SchoolClass;
use App\Models\Student;

class ManageDataService
{
    private static $instance;
    private $eduLevels;
    private $schoolClasses;
    private $students;
    private $messages = [];
    private $isCompleted = false;

    private function __construct()
    {
        $this->eduLevels = new EducationalLevel;
        $this->schoolClasses = new SchoolClass;
        $this->students = new Student;
    }

    public static function getInstance()
    {
        if (!isset(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function getMessages()
    {
        return $this->messages;
    }

    public function setMessages($messages)
    {
        $this->messages = $messages;
    }

    public function isCompleted()
    {
        // Ambil data terbaru
        $eduLevel = $this->eduLevels->latest()->first();
        $schoolClass = $this->schoolClasses->latest()->first();

        // Inisialisasi status tugas
        $statusEduLevel = false;
        $statusSchoolClass = false;

        // Cek apakah kelas pertama pada jenjang belum ada?
        if ($eduLevel) {
            $statusEduLevel = $this->schoolClasses->where('educational_level_id', $eduLevel->id)->exists();
        }

        if ($schoolClass) {
            $statusSchoolClass = $this->students->where('school_class_id', $schoolClass->id)->exists();
        }

        // Pesan-pesan untuk tugas yang belum selesai
        $messages = [];

        if (!$statusEduLevel) {
            $messages[] = [
                'feature' => 'Jenjang',
                'data' => 'Sekarang saatnya untuk membuat kelas. Masih ada form santri yang perlu diisi setelah kelas',
                'next-name' => 'kelas',
                'next-link' => route('institution.class')
            ];
        }

        if (!$statusSchoolClass) {
            $messages[] = [
                'feature' => 'Kelas',
                'data' => 'Sekarang saatnya untuk menambahkan santri',
                'next-name' => 'santri',
                'next-link' => route('institution.student')
            ];
        }

        // Jika semua tugas telah selesai, atur isCompleted ke true
        $this->setCompleted(empty($messages));

        // Simpan pesan-pesan
        $this->setMessages($messages);

        return $this->isCompleted;
    }


    public function setCompleted($isCompleted = false)
    {
        $this->isCompleted = $isCompleted;
    }
}
