<?php

namespace Services;

use App\Models\Payment;
use App\Models\Student;

class PaymentService
{
    public function model()
    {
        return Payment::with('bill_detail', 'bill_detail.bill', 'student');
    }

    public function store(
        $bill_detail_ids,
        $nis,
        $bank_account_number = null,
        $amounts,
        $description
    ) {
        $student = Student::where('nis', $nis)->first();

        if (count($bill_detail_ids) !== count($amounts)) {
            return;
        }

        for ($i = 0; $i < count($bill_detail_ids); $i++) {
            $bill_id = $bill_detail_ids[$i];
            $amount = $amounts[$i];

            $this->model()->create([
                'pay_code' => \lastBillPayment('BIL'),
                'bill_detail_id' => $bill_id,
                'student_id' => $student->id,
                'bank_account_number_bsn' => $bank_account_number,
                'amount' => $amount,
                'description' => $description,
                'last_reset_date' => now()->format('Y-m-d')
            ]);
        }
    }
}
