const BasicDataTable = (() => {
    'use strict';

    let dt_public_table;

    function initializeDataTable(basicTableConfig) {
        const {
            idTable,
            idFormModal,
            storeUrl,
            showUrl = '',
            editUrl,
            updateUrl,
            headerActionsPosition,
        } = basicTableConfig;

        const dt_basic_table = idTable;
        const dt_form_modal = idFormModal;

        dt_basic_table.show();

        if (dt_basic_table.length) {
            dt_public_table = dt_basic_table.DataTable({
                autoWidth: false,
                columnDefs: [
                    {
                        targets: [0, 1],
                        width: '5%',
                        orderable: false,
                        searchable: false,
                        checkboxes: true,
                    },
                    {
                        targets: headerActionsPosition,
                        orderable: false,
                        searchable: false,
                        render: (data, type, full, meta) => generateActionButtons(data, dt_form_modal, showUrl),
                    },
                ],
                dom:
                    '<"row mx-1"<"col-sm-12 col-md-3" l><"col-sm-12 col-md-9"<"dt-action-buttons text-xl-end text-lg-start text-md-end text-start d-flex align-items-center justify-content-md-end justify-content-center flex-wrap me-1"<"me-3"f>B>>>t<"row mx-2"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
                language: {
                    sLengthMenu: "_MENU_",
                    search: "Search",
                    searchPlaceholder: "Search..",
                },
                buttons: [
                    {
                        text: "Tambah",
                        className: "add-new btn btn-primary mb-3 mb-md-0",
                        attr: {
                            "data-bs-toggle": "modal",
                            "data-bs-target": "#" + dt_form_modal.attr('id'),
                        },
                        init: (api, node, config) => {
                            $(node).removeClass("btn-secondary");
                        },
                    },
                ],
            });
        }

        $('#head-cb').on('click', function () {
            $('.child-cb').prop('checked', this.checked);
        });

        $(document).on('click', '.item-delete', function () {
            const data = $(this).data('delete');
            if (!$('input[name="ids[]"]:checked').length > 0) {
                $('input[name="id-confirm"]').val(data);
            }
        });

        $(document).on('click', '.item-edit', function () {
            const id = $(this).data('edit');
            console.log('ngedit dulu gak seh?');
            const url = setupUrl({ edit: editUrl, update: updateUrl }, id);
            requestServer({
                url: url.edit,
                type: 'GET',
                dataType: 'json',
                success: basicTableConfig.requestServer,
            });
            dt_form_modal.find('input[name="_method"]').val('PUT');
            dt_form_modal.find('form').attr('action', url.update);
        });

        dt_form_modal.on('hidden.bs.modal', function () {
            $('.invalid-feedback').text('');
            $('.is-invalid').removeClass('is-invalid');
            $(this).find('form')[0].reset(); // Reset the form inputs
            $(this).find('form').attr('action', storeUrl);
            $(this).find('input[name="_method"]').val('POST'); // Reset the form method if needed
        });
    }

    return {
        initializeDataTable,
    };
})();
