// utils
/**
 * @param {*} url
 * @param {*} success
*/
function requestServer(params) {
    console.log('request dulu ges')
    $.ajax({
        url: params.url,
        type: params.type,
        dataType: params.dataType,
        success: params.success,
    })
}

/**
 * @param {*} route
 * @param {*} id
*/
function setupUrl(route, id) {
    let url = {}

    let urlEdit = route.edit.replace(':id', id)
    let urlUpdate = route.update.replace(':id', id)

    url = {
        edit: urlEdit,
        update: urlUpdate,
    }

    return url
}

/**
 * @param {*} modalElement
 * @param {*} formElement
 * @param {*} route
*/
function formAfterDismiss(modalElement, formElement, route) {
    modalElement.on('hidden.bs.offcanvas', function () {
        if (!$(this).hasClass('show')) {
            formElement[0].reset();
            formElement.attr('action', route);
            $(formElement.attr('id') + ' > input[name="_method"]').remove();
        }
    })
}

/**
 * @param {*} data
 * @param {*} modalTarget
 * @param {*} optionalUrlParams
*/
function generateActionButtons(data, modalTarget, optionalUrlParams) {
    const items = {};
    let add = optionalUrlParams.add ?? '';
    let show = optionalUrlParams.show ?? '';
    if (optionalUrlParams != null && optionalUrlParams.add || optionalUrlParams.show) {
        add = add.replace(':id', data)
        show = show.replace(':id', data)
        items.add = add.length > 0 ? `<a href="${add}" class="btn text-primary btn-icon item-show"><i class="bx bx-plus bx-sm"></i></a>` : ''
        items.show = show.length > 0 ? `<a href="${show}" class="btn text-warning btn-icon item-show"><i class="bx bx-show bx-sm"></i></a>` : ''
        return (
            `
            <a href="javascript:;" class="btn text-danger btn-icon item-delete" data-bs-toggle="modal" data-bs-target="#modal-confirm" data-delete="${data}"><i class="bx bxs-trash bx-sm"></i></a>
            <a href="javascript:;" class="btn text-primary btn-icon item-edit" data-bs-toggle="modal" data-bs-target="#${modalTarget.attr('id')}" data-edit="${data}"><i class="bx bxs-edit bx-sm"></i></a>
            ${items.add}
            ${items.show}
            `
        )
    }
    return (
        `
        <a href="javascript:;" class="btn btn-sm text-danger btn-icon item-delete" data-bs-toggle="modal" data-bs-target="#modal-confirm" data-delete="${data}"><i class="bx bxs-trash bx-sm"></i></a>
        <a href="javascript:;" class="btn btn-sm text-primary btn-icon item-edit" data-bs-toggle="modal" data-bs-target="#${modalTarget.attr('id')}" data-edit="${data}"><i class="bx bxs-edit bx-sm"></i></a>
        `
    )
}

// special from institution admin page
function previewImage(image, imgPreview) {
    const IMAGE = document.querySelector(image);
    const IMAGE_PREVIEW = document.querySelector(imgPreview);

    imgPreview.style.display = 'block';

    const oFReader = new FileReader();
    oFReader.readAsDataURL(IMAGE.files[0]);

    oFReader.onload = function (oFREvent) {
        IMAGE_PREVIEW.src = oFREvent.target.result;
    }
}

// selected option without attr value
function selectOptionByText(selectElement, text) {
    $(selectElement).find('option').filter(function () {
        return $(this).text() === text;
    }).prop('selected', true);
}

// showing populate dropdown
function populateDropdown(selectId, data, defaultOption) {
    const select = $(selectId);
    select.empty().append(`<option value="0" disabled selected>${defaultOption}</option>`);

    if (data.length != 0) {
        select.attr('disabled', false)
    } else {
        select.attr('disabled', true)
    }
    data.forEach(item => {
        select.append(`<option value="${item.id}">${item.name}</option>`);
    });
}

// fetching data and include populateDropdown
async function fetchAndPopulateDropdown(startSelect, endSelect, url, defaultOption) {
    try {
        const response = await $.ajax({
            url: url,
            type: 'GET',
            dataType: 'json',
            beforeSend: function () {
                $(endSelect).attr('disabled', true)
                $(endSelect).append('<option class"option-loading" selected>Loading...</option>')
            },
            complete: function () {
                $(endSelect).find('.option-loading').remove()
                $(endSelect).attr('disabled', false)
            },
        })

        populateDropdown(endSelect, response, defaultOption);
    } catch (error) {
        console.error('Error:', error);
    }
}
