

/**
 * @param {*} data
 * @param {*} modalTarget
 * @param {*} optionalUrlParams
*/
function generateActionButtons(data, optionalUrlParams) {
    const items = {};
    let add = optionalUrlParams.add ?? '';
    let show = optionalUrlParams.show ?? '';
    if (optionalUrlParams != null && optionalUrlParams.add || optionalUrlParams.show) {
        add = add.replace(':id', data)
        show = show.replace(':id', data)
        items.add = add.length > 0 ? `<a href="${add}" class="btn text-primary btn-xs btn-icon item-show"><i class="bx bx-plus bx-sm"></i></a>` : ''
        items.show = show.length > 0 ? `<a href="${show}" class="btn text-warning btn-xs btn-icon item-show"><i class="bx bx-show bx-sm"></i></a>` : ''
        return (
            `
            ${items.show}
            `
        )
    }
    return (
        `
        `
    )
}
