// require('./bootstrap');
console.clear();

let contributors = [
    {
        name: 'Yanuar Rizki Sanjaya',
        url: undefined,
        contribute: '💻'
    },
    {
        name: 'Riswan Hermawan',
        url: undefined,
        contribute: '💻'
    },
]

console.log('%cHayo mau ngapain, antum?', 'color: red; font-size: 40px;');
console.group('Contributors');
console.table(contributors);
console.groupEnd();
console.log('%c\n\nWith 💚 by Yanuar & All contributors. Makasi!', 'font-size: 14px;');


/**
 * Chart dashboard institution
 */
const chartConfig = {
    series: [{
        name: 'Bulan Ini',
        type: 'line',
        data: paymentsToday
    }, {
        name: 'Bulan Lalu',
        type: 'line',
        data: previousMonthData,
        opacity: 0.5
    }],
    chart: {
        height: 400,
        type: 'line',
        toolbar: {
            show: false
        },
        animations: {
            enabled: true,
            easing: 'easeinout',
            speed: 800,
            dynamicAnimation: {
                enabled: true,
                speed: 350
            }
        },
        dropShadow: {
            enabled: true,
            opacity: 0.3,
            blur: 5,
            left: -7,
            top: 22
        }
    },
    colors: ['#556ee6', '#f1b44c'],
    stroke: {
        width: [3, 3],
        curve: 'smooth',
        dashArray: [0, 5]
    },
    markers: {
        size: 4,
        strokeWidth: 2,
        hover: {
            size: 7
        }
    },
    grid: {
        borderColor: '#f1f1f1',
    },
    legend: {
        position: 'top',
        horizontalAlign: 'right',
        floating: true,
        offsetY: -25,
        offsetX: -5,
        labels: {
            useSeriesColors: true
        },
        fontFamily: 'Poppins, sans-serif',
        fontSize: '13px',
        fontWeight: 500
    },
    tooltip: {
        shared: true,
        intersect: false,
        y: [{
            formatter: function(y) {
                if (typeof y !== "undefined") {
                    return `Rp ${y.toLocaleString('id-ID')}`;
                }
                return y;
            }
        }, {
            formatter: function(y) {
                if (typeof y !== "undefined") {
                    return `Rp ${y.toLocaleString('id-ID')}`;
                }
                return y;
            }
        }]
    },
    xaxis: {
        type: 'datetime',
        categories: Object.keys(paymentsToday),
        labels: {
            style: {
                fontSize: '12px',
                fontFamily: 'Poppins, sans-serif'
            }
        }
    },
    yaxis: {
        title: {
            text: 'Pendapatan (Rp)',
            style: {
                fontSize: '13px',
                fontFamily: 'Poppins, sans-serif',
                fontWeight: 600
            }
        },
        labels: {
            style: {
                fontSize: '12px',
                fontFamily: 'Poppins, sans-serif'
            },
            formatter: function(val) {
                return 'Rp ' + val.toLocaleString('id-ID');
            }
        }
    }
};

// Initialize chart
const chart = new ApexCharts(document.querySelector("#chart"), chartConfig);
chart.render();

// Time range buttons
document.querySelectorAll('.btn-soft-primary').forEach(button => {
    button.addEventListener('click', function() {
        // Remove active class from all buttons
        document.querySelectorAll('.btn-soft-primary').forEach(btn => {
            btn.classList.remove('active');
        });
        // Add active class to clicked button
        this.classList.add('active');
        
        // Update chart data based on selected range
        // You'll need to implement this part based on your data structure
        updateChartData(this.id);
    });
});

function updateChartData(range) {
    // Implement your data update logic here
    // Example:
    switch(range) {
        case 'oneMonth':
            // Update data for 1 month
            break;
        case 'sixMonths':
            // Update data for 6 months
            break;
        case 'oneYear':
            // Update data for 1 year
            break;
        case 'all':
            // Update data for all time
            break;
    }
}
