<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title> @yield('title') | Edupay</title>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('/assets/img/favicon/favicon.png') }}" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet" />

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="{{ asset('./assets/vendor/fonts/boxicons.css') }}" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="{{ asset('./assets/vendor/css/core.css') }}" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{ asset('./assets/vendor/css/theme-default.css') }}"
        class="template-customizer-theme-css" />
    <link rel="stylesheet" href="{{ asset('./assets/css/demo.css') }}" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{ asset('./assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css') }}" />
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

    <link rel="stylesheet" href="{{ asset('./assets/vendor/libs/apex-charts/apex-charts.css') }}" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    {{--
        <link rel="stylesheet" href="{{ asset('./assets/vendor/libs/toastr/toastr.css') }}" /> --}}
    <link rel="stylesheet" href="{{ asset('./assets/vendor/css/pages/page-auth.css') }}" />
    {{-- <link rel="stylesheet" href="sweetalert2.min.css"> --}}
    @stack('css')

    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="{{ asset('./assets/vendor/js/helpers.js') }}"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="{{ asset('./assets/js/config.js') }}"></script>
</head>

<body>
    <!-- Content -->
    <style>
        .paham {
            /* Ubah gambar menjadi latar belakang */
            position: absolute;
            top: 2;
            left: 5;
            z-index: 1;
            pointer-events: none;

        }

        @media (max-width: 576px) {
            .geser {
                margin-left: -120%;
            }

            #formAuthentication {
                max-width: 100%;
                margin: 0;
            }
        }

        .swal2-styled.swal2-confirm:focus {
            box-shadow: var(--tw-ring-offset-shadow, 0 0 #0000), var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow);
        }

        .swal2-confirm.swal2-styled {
            border-radius: 0.25rem;
            border-width: 2px;
            border-style: solid;
            --tw-border-opacity: 1;
            border-color: rgb(255 106 0 / var(--tw-border-opacity));
            --tw-bg-opacity: 1;
            background-color: rgb(255 106 0 / var(--tw-bg-opacity));
            --tw-text-opacity: 1;
            color: rgb(255 255 255 / var(--tw-text-opacity));
            --tw-shadow: 0 0.125rem 0.25rem 0 rgba(255, 137, 105, 0.4);
            --tw-shadow-colored: 0 0.125rem 0.25rem 0 var(--tw-shadow-color);
            box-shadow: var(--tw-ring-offset-shadow, 0 0 #0000), var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow);
        }
    </style>
    <div class="container-xxl">
        <img src="{{ asset('/assets/img/favicon/logo.png') }}" alt="Logo Edupay" width="100px" height="auto"
            class="paham mt-5" data-aos="zoom-in">

        <div class="authentication-wrapper authentication-basic container-p-y" data-aos="zoom-in">
            <div class="geser">
                <img src="{{ asset('/assets/img/backgrounds') . '/' . $bg }}" alt="Logo Edupay"
                    style="z-index:1;margin-left:-9%">
            </div>
            <div class="top-0 start-0 h-100 wkwk col-8 col-lg-2"
                style="transform: scale(1.0);margin-left:-450px;z-index:2">
                @yield('content')
            </div>
        </div>
    </div>
    <!-- / Content -->
    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="{{ asset('./assets/vendor/libs/jquery/jquery.js') }}"></script>
    <script src="{{ asset('./assets/vendor/libs/popper/popper.js') }}"></script>
    <script src="{{ asset('./assets/vendor/js/bootstrap.js') }}"></script>
    <script src="{{ asset('./assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js') }}"></script>
    <!-- endbuild -->

    <!-- Main JS -->
    <script src="{{ asset('./assets/vendor/js/menu.js') }}"></script>
    <script src="{{ asset('./assets/js/main.js') }}"></script>
    {{-- <script src="{{ asset('./assets/js/ui-toasts.js') }}"></script> --}}
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="https://demos.themeselection.com/sneat-bootstrap-html-admin-template/documentation/assets/js/ui-toasts.js">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        AOS.init();
    </script>
    @if (session()->has('notif-fail'))
        <script>
            Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.addEventListener('mouseenter', Swal.stopTimer)
                    toast.addEventListener('mouseleave', Swal.resumeTimer)
                }
            }).fire({
                icon: 'error',
                title: "{{ session('notif-fail') }}",
            })
        </script>
    @endif
    @stack('js')
</body>

</html>
