<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>Edupay {{ isset($title) ? ' | ' . $title : '' }}</title>

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('/assets/img/favicon/favicon.png') }}" />
    <link rel="manifest" href="{{ asset('./assets/img/favicon') }}/site.webmanifest">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet" />

    <!-- Icons. Uncomment required icon fonts -->
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>

    <!-- Core CSS -->
    <link rel="stylesheet" href="{{ asset('./assets/vendor/css/core.css') }}" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{ asset('./assets/vendor/css/theme-default.css') }}"
        class="template-customizer-theme-css" />
    <link rel="stylesheet" href="{{ asset('./assets/css/demo.css') }}" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{ asset('./assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css') }}" />
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

    <link rel="stylesheet" href="{{ asset('./assets/vendor/libs/apex-charts/apex-charts.css') }}" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    {{-- <link rel="stylesheet" href="sweetalert2.min.css"> --}}
    {{-- <link rel="stylesheet" href="{{ asset('./assets/vendor/libs/toastr/toastr.css') }}" /> --}}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/spinkit@2.0.1/spinkit.min.css">
    <style>
        :root {
            --bs-body-bg: #F6FFF6 !important;
            --sk-color: grey;
        }

        .bg-footer-theme {
            background-color: var(--bs-body-bg) !important;
        }

        .bg-menu-theme .menu-inner>.menu-item.active>.menu-link {
            color: #129E4B;
            background-color: var(--bs-body-bg) !important;
        }

        .btn-primary {
            background-color: #137a61;
            border-color: #137a61;
            box-shadow: 0 0.125rem 0.25rem 0 rgba(246, 255, 246, 0.4);
        }

        .btn-primary:hover {
            background-color: #00e3bc;
            border-color: #00e3bc;
        }

        .skeleton,
        .skeleton-rounded {
            position: relative;
        }

        .skeleton::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 10;
            background: linear-gradient(90deg, #dadada, #e9e9e9, #e0e0e0);
            background-size: 200%;
            animation: skeleton 1s infinite reverse;
        }

        .skeleton-rounded::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 10;
            background: linear-gradient(90deg, #dadada, #e9e9e9, #e0e0e0);
            background-size: 200%;
            animation: skeleton 1s infinite reverse;
            border-radius: 100%;
        }

        @keyframes skeleton {
            0% {
                background-position: -100% 0;
            }

            100% {
                background-position: 100% 0;
            }
        }
    </style>
    @stack('css')

    <!-- Page CSS -->

    <!-- Helpers -->
    <script src="{{ asset('./assets/vendor/js/helpers.js') }}"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="{{ asset('./assets/js/config.js') }}"></script>
</head>

<body>
    <!-- Layout wrapper -->
    <div
        class="layout-wrapper layout-content-navbar layout-menu-fixed @if (auth()->user()->role == 'ADMIN') layout-without-menu @endif">
        {{-- <div class="layout-wrapper layout-content-navbar layout-without-menu"> --}}
        <div class="layout-container">
            <!-- Menu -->

            @include('partials.menu')

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->

                @include('partials.navbar')

                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container-xxl flex-grow-1 container-p-y">
                        @yield('content')
                    </div>
                    <!-- / Content -->
                    <!-- Footer -->
                    @include('partials.footer')
                    <!-- / Footer -->

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>

        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <!-- / Layout wrapper -->

    <!-- Show Modal -->
    @php
        $idGantiPass = 'gantiPass';
        $idLoading = 'modal-loading';
        $idSuccess = 'modal-success';
        $idError = 'modal-error';
        $isBackdrop = true;
    @endphp
    <!-- change password -->
    <x-show-modal :id="$idGantiPass">
        <div class="modal-header">
            <h5 class="modal-title" id="modalToggleLabel">
                <div id="modalToggleLabel2">Ganti Password</div>
            </h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <form id="formChangePassword" method="POST">
                @method('PATCH')
                @csrf
                <div class="row">
                    <div class="mb-3 form-password-toggle col-md-12">
                        <div class="d-flex justify-content-between">
                            <label class="form-label" for="old_password">Password Lama</label>
                        </div>
                        <div class="input-group input-group-merge">
                            <input type="password" id="old_password" class="form-control" name="old_password"
                                placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                aria-describedby="old_password" required />
                            <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                            <div class="invalid-feedback"></div>
                        </div>
                    </div>
                    <div class="mb-3 form-password-toggle col-md-6">
                        <div class="d-flex justify-content-between">
                            <label class="form-label" for="password">Password Baru</label>
                        </div>
                        <div class="input-group input-group-merge">
                            <input type="password" id="password" class="form-control" name="password"
                                placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                aria-describedby="password" required />
                            <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                            <div class="invalid-feedback"></div>
                        </div>
                    </div>
                    <div class="mb-3 form-password-toggle col-md-6">
                        <div class="d-flex justify-content-between">
                            <label class="form-label" for="password_confirmation">Verifikasi Password Baru</label>
                        </div>
                        <div class="input-group input-group-merge">
                            <input type="password" id="password_confirmation" class="form-control"
                                name="password_confirmation"
                                placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                aria-describedby="password_confirmation" required />
                            <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                            <div class="invalid-feedback"></div>
                        </div>
                    </div>
                </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                Batal
            </button>
            <input type="submit" name="Simpan" class="btn btn-primary" value="Simpan" id="submit">
        </div>
        </form>
    </x-show-modal>

    @stack('show-modal')

    <!-- loading -->
    <x-show-modal :id="$idLoading" :isBackdrop="$isBackdrop">
        <div class="modal-body">
            <div class="row justify-content-center align-items-center py-5">
                <div class="sk-bounce sk-primary mb-4">
                    <div class="sk-bounce-dot"></div>
                    <div class="sk-bounce-dot"></div>
                </div>
                <h3 class="text-center">Verifying your Data...</h3>
            </div>
        </div>
    </x-show-modal>
    <!-- success -->
    <x-show-modal :id="$idSuccess">
        <div class="modal-body">
            <div class="row justify-content-center align-items-center">
                <img src="{{ asset('assets/img/illustrations/Confirmed-bro.svg') }}" height="170" width="170"
                    style="object-fit: contain;">
                <h3 class="text-center mt-2">Data Berhasil Disimpan!</h3>
                <p class="text-center mt-2 col-md-7">Selamat!, perubahan kamu berhasil disimpan ke database.</p>
            </div>
        </div>
        <div class="modal-footer justify-content-center">
            <button type="button" class="btn btn-primary" data-bs-dismiss="modal">
                Oke
            </button>
        </div>
    </x-show-modal>
    <!-- error -->
    <x-show-modal :id="$idError">
        <div class="modal-body">
            <div class="row justify-content-center align-items-center">
                <img src="{{ asset('assets/img/illustrations/Software engineer-bro.svg') }}" height="170"
                    width="170" style="object-fit: contain;">
                <h3 class="text-center mt-2">Data Gagal Disimpan!</h3>
                <p class="text-center mt-2 col-md-7">Maaf, perubahan kamu gagal disimpan ke database, harap coba lagi.
                </p>
            </div>
        </div>
        <div class="modal-footer justify-content-center">
            <button type="button" class="btn btn-primary" data-bs-dismiss="modal">
                Oke
            </button>
        </div>
    </x-show-modal>


    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="{{ asset('./assets/vendor/libs/jquery/jquery.js') }}"></script>
    <script src="{{ asset('./assets/vendor/libs/popper/popper.js') }}"></script>
    <script src="{{ asset('./assets/vendor/js/bootstrap.js') }}"></script>
    <script src="{{ asset('./assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js') }}"></script>
    <!-- endbuild -->

    <!-- Main JS -->
    <script src="{{ asset('./assets/vendor/js/menu.js') }}"></script>
    <script src="{{ asset('./assets/js/main.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="https://demos.themeselection.com/sneat-bootstrap-html-admin-template/documentation/assets/js/ui-toasts.js">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script>
        window.addEventListener('load', function() {
            AOS.init({
                once: true,
            })
        })
    </script>
    @if (session()->has('notif-success'))
        <script>
            Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.addEventListener('mouseenter', Swal.stopTimer)
                    toast.addEventListener('mouseleave', Swal.resumeTimer)
                }
            }).fire({
                icon: 'success',
                title: "{{ session('notif-success') }}",
            })
        </script>
    @endif
    @if (session()->has('notif-error'))
        <script>
            Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.addEventListener('mouseenter', Swal.stopTimer)
                    toast.addEventListener('mouseleave', Swal.resumeTimer)
                }
            }).fire({
                icon: 'error',
                title: "{{ session('notif-error') }}",
            });
        </script>
    @endif
    <script>
        const allSekeleton = document.querySelectorAll('.skeleton')
        const allSekeletonRounded = document.querySelectorAll('.skeleton-rounded')
        window.addEventListener('load', function() {
            allSekeleton.forEach(item => {
                item.classList.remove('skeleton')
                if (item.classList.contains('skeleton') != true) {
                    $('.menu-item.active').addClass('open')
                }
            })
            allSekeletonRounded.forEach(item => {
                item.classList.remove('skeleton-rounded')
            })
        })
    </script>
    <script>
        $(document).ready(function() {
            $('#password').keyup(function() {
                const oldPass = $('#old_password').val()
                let pass = $(this).val()
                const inputField = $(this)
                if (oldPass === pass) {
                    const errorMessage = 'tidak boleh sama dengan password lama'
                    const feedbackElement = inputField.next(
                        ".invalid-feedback")

                    // Menampilkan pesan error ke dalam elemen "invalid-feedback"
                    feedbackElement.text(errorMessage)
                    $('.invalid-feedback').text(errorMessage)

                    // Menambahkan kelas "is-invalid" pada elemen input yang tidak valid
                    inputField.addClass("is-invalid")
                } else if (pass.length < 6) {
                    const errorMessage = 'tidak boleh kurang dari 6 karakter'
                    const feedbackElement = inputField.next(
                        ".invalid-feedback")

                    // Menampilkan pesan error ke dalam elemen "invalid-feedback"
                    feedbackElement.text(errorMessage)
                    $('.invalid-feedback').text(errorMessage)

                    // Menambahkan kelas "is-invalid" pada elemen input yang tidak valid
                    inputField.addClass("is-invalid")
                } else {
                    if (inputField.hasClass("is-invalid")) {
                        inputField.removeClass("is-invalid")
                    }
                }
            })

            $('#password_confirmation').keyup(function() {
                const pass = $('#password').val()
                let pass_confirm = $(this).val()
                const inputField = $(this)
                if (pass !== pass_confirm) {
                    const errorMessage = 'password tidak sesuai'
                    const feedbackElement = inputField.next(
                        ".invalid-feedback")

                    // Menampilkan pesan error ke dalam elemen "invalid-feedback"
                    feedbackElement.text(errorMessage)
                    $('.invalid-feedback').text(errorMessage)

                    // Menambahkan kelas "is-invalid" pada elemen input yang tidak valid
                    inputField.addClass("is-invalid")
                } else {
                    if (inputField.hasClass("is-invalid")) {
                        inputField.removeClass("is-invalid")
                    }
                }
            })

            $('#formChangePassword').submit(function(e) {
                e.preventDefault();

                // Menambahkan kondisi untuk memeriksa apakah ada elemen dengan class "is-invalid"
                if ($('.is-invalid').length > 0) {
                    // Jika ada, tampilkan pesan bahwa form tidak dapat disubmit karena ada error
                    alert("Form tidak dapat disubmit karena ada error pada input.")
                    return;
                }

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    type: 'POST',
                    dataType: 'json',
                    data: $(this).serialize(),
                    url: "{{ route('password.update') }}",
                    success: function(response) {
                        console.log(response)
                        $("#formChangePassword :input:not([type='hidden'])").val("")
                        $("#gantiPass").modal('hide')
                        $("#modal-loading").modal('show')

                        setTimeout(function() {
                            $("#modal-loading").modal('hide')
                            $("#modal-success").modal('show')
                        }, 2000);
                    },
                    error: function(xhr, status, error) {
                        if (xhr.status == 422) {
                            const errors = xhr.responseJSON.errors
                            Object.keys(errors).forEach(key => {
                                const errorMessage = errors[key][0]
                                const inputField = $("#" + key)
                                const feedbackElement = inputField.next(
                                    ".invalid-feedback")

                                // Menampilkan pesan error ke dalam elemen "invalid-feedback"
                                feedbackElement.text(errorMessage)
                                $('.invalid-feedback').text(errorMessage)

                                // Menambahkan kelas "is-invalid" pada elemen input yang tidak valid
                                inputField.addClass("is-invalid")
                            });
                        } else {
                            $("#formChangePassword :input:not([type='hidden'])").val("")
                            $("#gantiPass").modal('hide')
                            $("#modal-loading").modal('show')

                            setTimeout(function() {
                                $("#modal-loading").modal('hide')
                                $("#modal-error").modal('show')
                            }, 2000);
                        }
                    }
                })
            })
        })
    </script>
    <script>
        function formatNumber(input) {
            var value = input.value.replace(/\D/g, '');
            var formattedValue = '';
            var separator = '.';
            var count = 0;
            for (var i = value.length - 1; i >= 0; i--) {
                formattedValue = value.charAt(i) + formattedValue;
                count++;
                if (count % 3 === 0 && i !== 0) {
                    formattedValue = separator + formattedValue;
                }
            }

            input.value = formattedValue;
        }

        function numberFormat(number, decimals = 2, decPoint = '.', thousandsSep = ',') {
            number = parseFloat(number).toFixed(decimals);
            var parts = number.toString().split('.');
            parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, thousandsSep);
            return parts.join(decPoint);
        }
    </script>
    <script>
        $(document).ready(function() {
            $('#{{ $idGantiPass }}').on('hidden.bs.modal', function() {
                $(this).find('form').trigger('reset');
            })
        })
    </script>
    @stack('js')
</body>

</html>
