@extends('layouts.dashboard', ['title' => 'Konfigurasi'])

@section('content')
    @push('css')
        <style>
            .btn-card {
                transition: transform 0.3s ease;
            }

            .btn-card:hover {
                transform: translateY(-5px);
            }
        </style>
    @endpush
    {{-- <div class="row">
    <div class="col">
        <h4 class="text-primary"><span class="skeleton"> Konfigurasi </span></h4>
    </div>
</div> --}}
    <div class="row">
        <h4 class="fw-bold py-3 mb-4">
            <span class="text-muted fw-light skeleton"><a href="/">Dashboard</a>
                /</span>
            <span class="skeleton">Konfigurasi</span>
        </h4>
        <div class="card gambar">
            <div class="d-flex align-items-end row">
                <div class="card-header">

                    <h3 class="card-title mt-0"><span class="skeleton"> Konfigurasi Database</span></h3>
                </div>
                <div class="card-body">
                    <div class="row justify-content-start mt-1 mb-5">

                        <div class="col-lg-2 col-12 mb-4">



                            <div class="skeleton-rounded btn-card" style="width: 130px; height: 130px;">
                                <a href="{{ route('user') }}"> <img
                                        src="{{ asset('assets/img/icons/dashboard/backup.png') }}" alt="Backup image"
                                        style="width: 100%; height: 100%; overflow:hidden;" /></a>
                            </div>



                        </div>
                        <div class="col-lg-4 col-12">

                            <form id="form-id" action="{{ route('config.store') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                <h5 class="card-title"><span class="skeleton"> Restore Database </span>
                                </h5>
                                <div class="row">
                                    <div class="col">
                                        <input class="form-control skeleton" type="file" id="formFile"
                                            name="restore_file" accept=".sql" required />
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-8">
                                        <input type="submit" name="restore" value="Restore"
                                            class="btn btn-md btn-warning my-3 mr-3 skeleton">
                                    </div>
                                </div>
                            </form>

                        </div>

                    </div>
                </div>
            </div>
        </div>
        <div class="card gambar mt-4">
            <div class="d-flex align-items-end row">
                <div class="card-header">
                    <h3 class="card-title mt-0"><span class="skeleton"> Manajemen Integrasi Aplikasi</span></h3>
                </div>
                <div class="card-body">
                    <x-basic-data-table :id="$idApiTokenTable" :routeDelete="route('config.api-token.destroy')" :headers="$headers" :rows="$rows" />
                </div>
            </div>
        </div>
    </div>
    @push('show-modal')
        @php
            $formModal = 'formConfigModal';
        @endphp
        {{-- FORM MODAL --}}
        <x-show-modal :id="$formModal">
            <div class="modal-header">
                <h5 class="modal-title" id="modalToggleLabel">
                    <div id="modalToggleLabel2"></div>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('config.api-token.store') }}" method="POST">
                    @csrf
                    @method('POST')
                    <div class="row">
                        @field([
                            'label' => 'Nama Aplikasi',
                            'name' => 'name',
                            'placeholder' => 'bsn',
                            'type' => 'text',
                        ])
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    Batal
                </button>
                <button type="submit" class="btn btn-primary">
                    Simpan
                </button>
            </div>
            </form>
        </x-show-modal>
    @endpush

    @push('js')
        <!-- Include Utils -->
        <script src="{{ asset('assets/js/utils.js') }}"></script>
        <!-- Setup DataTable -->
        <script src="{{ asset('assets/js/basic-table-ajax.js') }}"></script>
        <script>
            $(document).ready(function() {
                let idTable = "#:id".replace(":id", "{{ $idApiTokenTable }}");
                let idFormModal = "#:id".replace(":id", "{{ $formModal }}");
                BasicDataTable.initializeDataTable({
                    storeUrl: "{{ route('config.api-token.store') }}",
                    editUrl: "{{ route('config.api-token.edit', ':id') }}",
                    updateUrl: "{{ route('config.api-token.update', ':id') }}",
                    idTable: $(idTable),
                    idFormModal: $(idFormModal),
                    headerActionsPosition: 5,
                    requestServer: function(data) {
                        $(idFormModal).find('input[name="_method"]').val('PUT')
                        $('input[name="name"]').val(data.name)
                    },
                });
            });
        </script>
        <script src="https://cdn.jsdelivr.net/npm/clipboard@2.0.11/dist/clipboard.min.js"></script>
        <script>
            const clipboardList = [].slice.call(document.querySelectorAll('.clipboard-btn'));

            if (ClipboardJS) {
                clipboardList.map(function(clipboardEl) {
                    const clipboard = new ClipboardJS(clipboardEl);
                    clipboard.on('success', function(e) {
                        if (e.action == 'copy') {
                            toastr['success']('', 'Copied to Clipboard!!');
                        }
                    });
                });
            } else {
                clipboardList.map(function(clipboardEl) {
                    clipboardEl.setAttribute('disabled', true);
                });
            }
        </script>
    @endpush
@endsection
