@extends('layouts.dashboard')

@section('title')
Daftar Tagihan {{ $bill->name }}
@endsection

@section('content')
@push('css')
<link rel="stylesheet" href="{{ asset('assets/vendor/libs/dataTables/dataTables.bootstrap5.min.css') }}">
<link href="https://cdn.datatables.net/v/bs5/dt-1.13.6/rg-1.4.0/datatables.min.css" rel="stylesheet">
@endpush
<div class="row">
    <h4 class="fw-bold py-3 mb-4">
        <span class="text-muted fw-light"><a href="/">Dashboard</a>
            /
            <a href="{{ route('institution.bill') }}">Tagihan</a> / </span>
        {{ $bill->name }}
    </h4>
    <div class="row mb-3 align-items-end">
        @if ( $categories == 'Bulanan' )
        <div class="col-lg-3 col-6 mb-1">
            <label for="" class="form-label">Dari Bulan</label>
            @php
            $currentMonth = date('Y-m');
            @endphp
            <input type="month" class="form-control" name="bln1" id="bln1" value="{{ $currentMonth }}">
        </div>
        <div class="col-lg-3 col-6 mb-1">
            <label for="" class="form-label">Sampai Bulan</label>
            @php
            $nextMonth = date('Y-m', strtotime('+1 month'));
            @endphp
            <input type="month" class="form-control" name="bln2" id="bln2" value="{{ $nextMonth }}">
        </div>
        <div class="col-lg-2 col-6 mb-1">
            <label for="" class="form-label">&nbsp;</label>
            <button type="button" class="btn btn-primary btn-full-width" name="tampilkan" id="tampilkan">Cari</button>
        </div>
        @else
        <div class="col-lg-8 col-6 mb-1">
            Tagihan : <span class="fs-4">{{ $bill->name }}</span>
        </div>
        @endif
        <div class="col-lg-4 col-6">
            <div class="text-center float-end mb-1">
                <label for="" class="form-label">&nbsp;</label>
                Total: Rp. <span id="total-terbayar" class="fs-4 text-primary">{{ number_format($totalAmount, 0, ',',
                    '.') .
                    ',-' }}</span>
            </div>
        </div>
    </div>

    <div class="col">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col">
                        <div class="table-responsive">
                            <div class="table-scroll-wrapper">
                                <x-basic-data-table-detail :id="$idBillDetails" :headers="$headers" :rows="$rows" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('css')
<style>
    .table-scroll-wrapper {
        position: relative;
        width: 100%;
        overflow-x: auto;
    }

    #{{ $idBillDetails }} {
        width: 100% !important;
        margin-bottom: 0;
    }

    /* Mengatur lebar minimum kolom */
    #{{ $idBillDetails }} th,
    #{{ $idBillDetails }} td {
        white-space: nowrap;
    }

    #{{ $idBillDetails }} th:first-child,
    #{{ $idBillDetails }} td:first-child { min-width: 40px; }  /* Checkbox */
    #{{ $idBillDetails }} th:nth-child(2),
    #{{ $idBillDetails }} td:nth-child(2) { min-width: 50px; }  /* No */
    #{{ $idBillDetails }} th:nth-child(3),
    #{{ $idBillDetails }} td:nth-child(3) { min-width: 200px; } /* Nama */
    #{{ $idBillDetails }} th:nth-child(4),
    #{{ $idBillDetails }} td:nth-child(4) { min-width: 150px; } /* Nominal */
    #{{ $idBillDetails }} th:nth-child(5),
    #{{ $idBillDetails }} td:nth-child(5) { min-width: 120px; } /* Tanggal */
    #{{ $idBillDetails }} th:last-child,
    #{{ $idBillDetails }} td:last-child { 
        min-width: 100px;
        position: sticky;
        right: 0;
        background: white;
        z-index: 1;
    }

    /* Dark mode support */
    [data-bs-theme="dark"] #{{ $idBillDetails }} td:last-child,
    [data-bs-theme="dark"] #{{ $idBillDetails }} th:last-child {
        background: var(--bs-body-bg);
    }

    /* Responsive adjustments */
    @media screen and (max-width: 768px) {
        .dt-buttons {
            margin-top: 1rem;
            justify-content: flex-start !important;
        }
        
        .dataTables_filter {
            margin-top: 1rem;
            width: 100%;
        }
        
        .dataTables_length {
            text-align: left;
        }
    }
</style>
@endpush
@push('js')
<script src="{{ asset('assets/vendor/libs/dataTables/dataTables.min.js') }}"></script>
<script src="{{ asset('assets/vendor/libs/dataTables/dataTables.bootstrap5.min.js') }}"></script>
<script src="https://cdn.datatables.net/buttons/1.7.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/v/bs5/dt-1.13.6/rg-1.4.0/datatables.min.js"></script>
@endpush
@push('js')
<!-- Include Utils -->
<script src="{{ asset('assets/js/utils2.js') }}"></script>
<!-- Define Basic Table Config -->
<script>
    const basic_table_config = {
        showUrl: {
            show: "{{ route('institution.student.show', ':id') }}",
        },
        idTable: $('#' + '{{ $idBillDetails }}'),
        header_actions_position: 6,
        
    }
</script>
<!-- Setup DataTable -->
<script src="{{ asset('assets/js/basic-table-ajax2.js') }}"></script>
<script>
    $(document).ready(function() {
        $('#tampilkan').click(function() {
            var bln1 = $('#bln1').val();
            var bln2 = $('#bln2').val();
            var currentUrl = window.location.href;
            var newUrl = currentUrl.split('?')[0] + '?';
            if (bln1) {
                newUrl += 'bln1=' + bln1;
            }
            if (bln2) {
                newUrl += (bln1 ? '&' : '') + 'bln2=' + bln2;
            }
            window.location.href = newUrl;
        });
    });
</script>
@endpush
@endsection
