@extends('layouts.dashboard', ['title' => 'Tambah Kelas'])

@section('content')
    <div class="row">
        <h4 class="py-3 mb-4">
            <x-breadcrumb :items="[
                [
                    'title' => 'Kelas',
                    'route' => route('institution.class'),
                ],
                [
                    'title' => 'Tambah Kelas',
                    'route' => null,
                ],
            ]" />
        </h4>
        <div class="col">
            <h5>Data Statis</h5>
            <form method="POST" id="form-single">
                <div class="card mb-4 form-row" id="form-row">
                    <div class="modal-header card-many-close" style="display: none;">
                        <button type="button" class="btn-close btn-danger py-2" aria-label="Close"></button>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="remove-eduLevel">
                                @field([
                                    'label' => 'Pilih Jenjang',
                                    'name' => 'eduLevel[]',
                                    'type' => 'select',
                                    'options' => $eduLevels->map(function ($eduLevel) {
                                            return '<option value="' . $eduLevel->id . '">' . $eduLevel->name . '</option>';
                                        })->join(' '),
                                ])
                            </div>
                            <div class="remove-batch">
                                @field([
                                    'label' => 'Angkatan',
                                    'name' => 'batch[]',
                                    'placeholder' => '7',
                                    'type' => 'text',
                                ])
                            </div>
                            @field([
                                'label' => 'Nama Kelas',
                                'name' => 'name[]',
                                'placeholder' => '7-A',
                                'type' => 'text',
                            ])
                        </div>
                    </div>
                </div>
            </form>
            <div class="d-flex justify-content-end gap-2">
                <button type="button" class="btn btn-secondary">
                    Batal
                </button>
                <button type="submit" class="btn btn-primary" id="btn-save">
                    Simpan
                </button>
            </div>
        </div>

        <div class="col">
            <h5>Data Dinamis</h5>
            <div class="card mb-4" style="height: 300.891px" id="card-select">
                <div class="card-header">
                    <div class="card-actions d-flex gap-2">
                        <div class="col">
                            <select name="insert_category" class="form-select mb-3">
                                <option value="" disabled selected>Pilih Kategori</option>
                                <option value="class">Nama Kelas</option>
                                <option value="all">Semua Kelas</option>
                            </select>
                            <input type="number" name="amount" class="form-control" placeholder="Jumlah">
                        </div>
                        <button type="button" class="btn btn-icon btn-primary" id="btn-add">
                            <i class="bx bx-plus bx-sm"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row" id="illustration-add">
                        <img src="{{ asset('assets/img/illustrations/Add notes-bro.svg') }}" height="150" width="150"
                            style="object-fit: contain;">
                    </div>
                </div>
            </div>
            <form method="POST" id="form-many">
            </form>
        </div>
    </div>

    @push('js')
        <!-- include BlockUI -->
        <script src="https://cdn.jsdelivr.net/npm/jquery-blockui@2.7.0/jquery.blockUI.min.js"></script>
        <script>
            $(document).ready(function() {
                const btnAdd = $('#btn-add');
                // Event ketika tombol "Tambah Kelas" diklik
                $('#btn-add').on('click', function() {
                    if (btnAdd.hasClass('btn-danger')) {
                        btnAdd.toggleClass('btn-danger btn-primary');
                    }
                    let selectedCategory = $('select[name="insert_category"]').val();
                    if (selectedCategory === null) {
                        alert('Pilih kategori terlebih dahulu!');
                        return;
                    }
                    whenCardAction();
                    cloneFormRows();
                    let eduLevelDefault = $('#form-single').find('select[name="eduLevel[]"]').val();
                    $('#form-many').find('select[name="eduLevel[]"]').val(eduLevelDefault).change();
                });

                // Event ketika tombol "Simpan" diklik
                $('#btn-save').on('click', function() {
                    const selectedCategory = $('select[name="insert_category"]').val();
                    const formSingle = $('#form-single');
                    const formMany = $('#form-many');

                    if (selectedCategory === 'class') {
                        const batchInput = formSingle.find('input[name="batch[]"]');
                        const batchInputs = formMany.find('input[name="batch[]"]');
                        const nameInputs = formMany.find('input[name="name[]"]');

                        if (!batchInput.val()) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Data Statis Pada Angkatan Harap Diisikan!',
                                didClose: () => {
                                    batchInput.focus();
                                }
                            });
                            return;
                        }

                        if (batchInputs.length === 0 || nameInputs.length === 0) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Tambahkan Form Terlebih Dahulu!',
                                didClose: () => {
                                    btnAdd.toggleClass('btn-primary btn-danger');
                                    btnAdd.focus();
                                }
                            });
                            return;
                        }

                        if (batchInputs.filter(function() {
                                return this.value !== '';
                            }).length === 0 ||
                            nameInputs.filter(function() {
                                return this.value !== '';
                            }).length === 0) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Field Input Masih Ada yang Kosong!',
                            });
                            return;
                        }
                    } else if (selectedCategory === 'all') {
                        const batchInputs = formMany.find('input[name="batch[]"]');
                        const nameInputs = formMany.find('input[name="name[]"]');

                        if (batchInputs.length === 0 || nameInputs.length === 0) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Tambahkan Form Terlebih Dahulu!',
                                didClose: () => {
                                    btnAdd.toggleClass('btn-primary btn-danger');
                                    btnAdd.focus();
                                }
                            });
                            return;
                        }

                        if (batchInputs.filter(function() {
                                return this.value !== '';
                            }).length === 0 ||
                            nameInputs.filter(function() {
                                return this.value !== '';
                            }).length === 0) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Field Input Masih Ada yang Kosong!',
                            });
                            return;
                        }
                    } else {
                        const batchInput = formSingle.find('input[name="batch[]"]');
                        const nameInput = formSingle.find('input[name="name[]"]');
                        if (!batchInput.val() || !nameInput.val()) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Field Input Masih Ada yang Kosong!',
                            });
                            return;
                        }
                    }

                    saveFormData();
                });



                // Event ketika jenjang diselect, dan angkatan diketik
                $('.remove-eduLevel').find('select[name="eduLevel[]"]').on('change', function(e) {
                    let optionSelected = $("option:selected", this);
                    changeValueIsHidden($('select[name="eduLevel[]"]'), optionSelected.val(), "select")
                });
                $('.remove-batch').find('input[name="batch[]"]').on('keyup', function() {
                    changeValueIsHidden($('input[name="batch[]"]'), $(this).val())
                });

                function changeValueIsHidden(otherInput, thisInputVal, type) {
                    if (otherInput.is(':hidden')) {
                        if (type === "select") {
                            otherInput.val(thisInputVal).change();
                        } else {
                            otherInput.val(thisInputVal);
                        }
                    }
                }

                function whenCardAction() {
                    $('#illustration-add').hide();
                    $('#card-select').css('height', 'auto');
                }

                function cloneFormRows() {
                    let selectedCategory = $('select[name="insert_category"]').val();
                    let amount = parseInt($('input[name="amount"]').val()) || 1;

                    for (let index = 0; index < amount; index++) {
                        let clonedRow = $('#form-row').clone();

                        if (selectedCategory === "class") {
                            clonedRow.find('.remove-eduLevel').hide();
                            clonedRow.find('.remove-batch').hide();
                        } else {
                            clonedRow.find('input[name="batch[]"]').val('');
                        }

                        clonedRow.find('input[name="name[]"]').val('');

                        clonedRow.find('.modal-header').show();
                        clonedRow.find('.btn-close').on('click', function() {
                            $(this).closest('.form-row').remove();
                            showIllustrationAdd();
                        });
                        $('#form-many').append(clonedRow);
                    }
                }

                function showIllustrationAdd() {
                    if ($('#form-many .form-row').length === 0) {
                        $('#illustration-add').show();
                        $('#card-select').css('height', '300.891px');
                    }
                }

                function saveFormData() {
                    let route = "{{ route('institution.class.store') }}";
                    let formDataSingle = $('#form-single').serialize();
                    let formDataMany = $('#form-many').serialize();
                    let combinedData = formDataSingle + '&' + formDataMany;

                    $.ajax({
                        url: route,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        type: 'POST',
                        dataType: 'json',
                        data: combinedData,
                        beforeSend: function() {
                            $('html').block({
                                message: '<div class="spinner-border text-primary" role="status"></div>',
                                timeout: 0,
                                css: {
                                    backgroundColor: "transparent",
                                    border: "0"
                                },
                                overlayCSS: {
                                    backgroundColor: "#000",
                                    opacity: 0.25
                                }
                            })
                        },
                        success: function(response) {
                            console.log(response);
                            if (!response.success) {
                                Swal.fire({
                                    icon: 'error',
                                    title: response.description,
                                });
                            } else {
                                Swal.fire({
                                    icon: 'success',
                                    title: response.description,
                                    didClose: (result) => {
                                        $('#form-single input').val("")
                                        $('input[name="amount"]').val("")
                                        $('#form-many').html("");
                                        showIllustrationAdd();
                                    }
                                });
                            }
                        },
                        error: function(xhr, error, status) {
                            console.log(xhr);
                            console.log(error);
                            console.log(status);
                            // Swal.mixin({
                            //     position: 'center',
                            //     showConfirmButton: true,
                            // }).fire({
                            //     icon: 'error',
                            //     title: xhr.responseJSON.message,
                            // });
                        },
                        complete: function() {
                            // This function will run when the request (success or error) is complete
                            // You can unblock the page here
                            $('html').unblock();
                        }
                    });
                }
            });
        </script>
    @endpush
@endsection
