@extends('layouts.dashboard', ['title' => 'Kelas'])

@section('content')
    <div class="row">
        <h4 class="py-3 mb-4">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="/">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active">Kelas</li>
                </ol>
            </nav>
        </h4>
        <div class="col">
            @alertDataManage()
            <div class="card">
                <div class="card-body">
                    <x-basic-data-table :id="$idSchoolClassTable" :routeDelete="route('institution.class.destroy')" :headers="$headers" :rows="$rows" />
                </div>
            </div>
        </div>
    </div>
    @push('show-modal')
        @php
            $formModal = 'formClassModal';
        @endphp
        {{-- FORM MODAL --}}
        <x-show-modal :id="$formModal">
            <div class="modal-header">
                <h5 class="modal-title" id="modalToggleLabel">
                    <div id="modalToggleLabel2"></div>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('institution.class.store') }}" method="POST" id="formSchoolClass">
                    @csrf
                    @method('POST')
                    <div class="row">
                        @field([
                            'label' => 'Pilih Jenjang',
                            'name' => 'eduLevel',
                            'type' => 'select',
                            'options' => $eduLevels->map(function ($eduLevel) {
                                    return '<option value="' . $eduLevel->id . '">' . $eduLevel->name . '</option>';
                                })->join(' '),
                        ])
                        @field([
                            'label' => 'Angkatan',
                            'name' => 'batch',
                            'placeholder' => '7',
                            'type' => 'text',
                        ])
                        @field([
                            'label' => 'Nama Kelas',
                            'name' => 'name',
                            'placeholder' => '7-A',
                            'type' => 'text',
                        ])
                    </div>
            </div>
            <div class="modal-footer d-flex justify-content-between">
                <a href="{{ route('institution.class.create') }}" class="text-underline">
                    <i class='bx bx-link-external'></i>
                    Tambah Lebih...
                </a>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                        Batal
                    </button>
                    <button type="submit" class="btn btn-primary">
                        Simpan
                    </button>
                </div>
            </div>
            </form>
        </x-show-modal>
    @endpush
    @push('js')
        <!-- Include Utils -->
        <script src="{{ asset('assets/js/utils.js') }}"></script>
        <!-- Setup Custom DataTable Lib -->
        <script src="{{ asset('assets/js/basic-table-ajax.js') }}"></script>
        <script>
            $(document).ready(function() {
                let idTable = "#:id".replace(":id", "{{ $idSchoolClassTable }}");
                let idFormModal = "#:id".replace(":id", "{{ $formModal }}");

                BasicDataTable.initializeDataTable({
                    storeUrl: "{{ route('institution.class.store') }}",
                    editUrl: "{{ route('institution.class.edit', ':id') }}",
                    updateUrl: "{{ route('institution.class.update', ':id') }}",
                    idTable: $(idTable),
                    idFormModal: $(idFormModal),
                    headerActionsPosition: 5,
                    requestServer: function(data) {
                        console.log(data);
                        $('#{{ $formModal }}' + '').find('input[name="_method"]').val('PUT');
                        $('input[name="name"]').val(data.name);
                        $('input[name="batch"]').val(data.batch);
                        $('select[name="eduLevel"]').val(data.educational_level_id).change();
                    },
                });
            });
        </script>
    @endpush
@endsection
