@extends('layouts.dashboard')

@section('title')
    Santri
@endsection

@section('content')
    @push('css')
        <link rel="stylesheet" href="{{ asset('./assets/vendor/libs/select2/select2.css') }}">
        </link>
        <link rel="stylesheet"
            href="https://cdn.jsdelivr.net/npm/@ttskch/select2-bootstrap4-theme@x.x.x/dist/select2-bootstrap4.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
    @endpush
    <div class="d-flex justify-content-between align-items-center">
        <h4 class="py-3 mb-4">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="/">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active">Manajemen Santri</li>
                </ol>
            </nav>
        </h4>
        <div class="d-flex gap-2 align-items-center">
            <a class="btn btn-outline-warning" href="{{ route('institution.student.export') }}">
                <span class='tf-icons bx bxs-file-export me-1'></span>
                Export
            </a>
            <button class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#student-import-modal">
                <span class='tf-icons bx bxs-file-import m-1'></span>
                Import
            </button>
        </div>
    </div>
    <div class="row">
        <div class="col">
            @if (session()->has('failures'))
                <div class="alert alert-danger border border-danger alert-dismissible" role="alert">
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                    </button>
                    <table class="table table-bordered border-danger py-4">
                        <thead>
                            <tr>
                                <th>Baris</th>
                                <th>Atribut</th>
                                <th>Error</th>
                                <th>Value</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach (session('failures') as $failure)
                                <tr>
                                    <td>{{ $failure->row() }}</td>
                                    <td>{{ $failure->attribute() }}</td>
                                    <td>
                                        <ul>
                                            @foreach ($failure->errors() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </td>
                                    <td>
                                        <ul>
                                            @foreach ($failure->values() as $value)
                                                <li>{{ $value }}</li>
                                            @endforeach
                                        </ul>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
            @alertDataManage()
            <div class="card">
                <div class="card-body">
                    <x-basic-data-table :id="$idStudentTable" :routeDelete="route('institution.student.destroy')" :headers="$headers" :rows="$rows" />
                </div>
            </div>
        </div>
    </div>
    @push('show-modal')
        @php
            $formModal = 'formClassModal';
        @endphp
        {{-- FORM MODAL --}}
        <x-show-modal :id="$formModal">
            <div class="modal-header">
                <h5 class="modal-title" id="modalToggleLabel">
                    <div id="modalToggleLabel2"></div>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('institution.student.store') }}" method="POST">
                    @csrf
                    @method('POST')
                    <div class="row">
                        @field([
                            'label' => 'NIS',
                            'name' => 'nis',
                            'placeholder' => '201200001',
                            'type' => 'text',
                        ])
                        @field([
                            'label' => 'Nama Lengkap',
                            'name' => 'name',
                            'placeholder' => 'ABDULLAH AL-ARIF',
                            'type' => 'text',
                        ])
                        @field([
                            'label' => 'Kelas',
                            'name' => 'school_class',
                            'type' => 'select',
                            'options' => $educational_levels->map(function ($educational_level) {
                                    return '<optgroup label="' .
                                        $educational_level->name .
                                        '">' .
                                        $educational_level->schoolClasses->map(function ($school_class) {
                                                return '<option value="' . $school_class->id . '">' . $school_class->name . '</option>';
                                            })->join(' ') .
                                        '</optgroup>';
                                })->join(' '),
                        ])
                        @field([
                            'label' => 'No Telephone',
                            'name' => 'phone',
                            'placeholder' => '0856 xxxx xxxx',
                            'type' => 'text',
                        ])
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    Batal
                </button>
                <button type="submit" class="btn btn-primary">
                    Simpan
                </button>
            </div>
            </form>
        </x-show-modal>
        <x-show-modal :id="'student-import-modal'">
            <div class="modal-header">
                <h5 class="modal-title" id="backDropModalTitle">Import Santri</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('institution.student.import') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('POST')
                    <div class="row">
                        <div class="col">
                            <input class="form-control skeleton" type="file" id="formFile" name="santri_file" accept=".xlsx"
                                required />
                        </div>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    Batal
                </button>
                <a class="btn btn-info" href="{{ route('institution.student.importFormat') }}">
                    Unduh Format
                </a>
                <button type="submit" class="btn btn-primary">
                    Import
                </button>
            </div>
            </form>
        </x-show-modal>
    @endpush
    @push('js')
        {{-- <script src="{{ asset('./assets/vendor/libs/select2/select2.js') }}"></script> --}}
        <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
        <!-- Include Utils -->
        <script src="{{ asset('assets/js/utils.js') }}"></script>
        <script src="{{ asset('assets/js/basic-table-ajax.js') }}"></script>
        <script>
            $(document).ready(function() {
                let idTable = "#:id".replace(":id", "{{ $idStudentTable }}");
                let idFormModal = "#:id".replace(":id", "{{ $formModal }}");

                $("#school_class").select2({
                    dropdownParent: $('#' + "{{ $formModal }}")
                });

                BasicDataTable.initializeDataTable({
                    storeUrl: "{{ route('institution.student.store') }}",
                    editUrl: "{{ route('institution.student.edit', ':id') }}",
                    updateUrl: "{{ route('institution.student.update', ':id') }}",
                    showUrl: {
                        show: "{{ route('institution.student.show', ':id') }}",
                    },
                    idTable: $(idTable),
                    idFormModal: $(idFormModal),
                    headerActionsPosition: 6,
                    requestServer: function(data) {
                        $('#' + '{{ $formModal }}').find('input[name="_method"]').val('PUT')
                        $('input[name="nis"]').val(data.nis)
                        $('input[name="name"]').val(data.name)
                        $('select[name="school_class"]').val(data.school_class_id).change()
                        $('input[name="phone"]').val(data.phone)
                    },
                });
            });
        </script>
    @endpush
@endsection
