

<?php $__env->startSection('title'); ?>
Settlement
<?php $__env->stopSection(); ?>


<?php $__env->startPush('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/dataTables/dataTables.bootstrap5.min.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="row">
    <h4 class="py-3 mb-4">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="/">Dashboard</a>
                </li>
                <li class="breadcrumb-item active">Settlement</li>
            </ol>
        </nav>
    </h4>

    <div class="card">
        <div class="d-flex align-items-end row">
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-9 col-12">
                        <form action="<?php echo e(route('institution.settlement.filter')); ?>" method="GET">
                            <div class="row">
                                <div class="col-lg-8">
                                    <div class="row">
                                        <h4 class="card-title">
                                            Settlement
                                        </h4>

                                        <div class="col-lg-4 col-4 mb-2">

                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" value="bulanan"
                                                    id="filter-bulanan" name="waktu" />
                                                <label class="form-check-label" for="defaultRadio1"> Bulanan </label>
                                            </div>
                                        </div>
                                        <div
                                            class="col-lg-4 col-4 d-flex align-items-center justify-content-start mb-2">
                                            <select name="bulan" id="bulan-select" class="form-control ">
                                                <option value="" disabled selected>Pilih Bulan</option>
                                                <option value="1">Januari</option>
                                                <option value="2">Februari</option>
                                                <option value="3">Maret</option>
                                                <option value="4">April</option>
                                                <option value="5">Mei</option>
                                                <option value="6">Juni</option>
                                                <option value="7">Juli</option>
                                                <option value="8">Agustus</option>
                                                <option value="9">September</option>
                                                <option value="10">Oktober</option>
                                                <option value="11">November</option>
                                                <option value="12">Desember</option>
                                            </select>
                                        </div>
                                        <div
                                            class="col-lg-4 col-4 d-flex align-items-center justify-content-start mb-2">
                                            <select name="tahun" id="tahun-select" class="form-control">
                                                <option value="">Tahun</option>
                                                <?php
                                                    $currentYear = (int)date('Y');
                                                    $startYear = $currentYear - 5;
                                                    $endYear = $currentYear + 5;
                                                    
                                                    for($year = $startYear; $year <= $endYear; $year++) {
                                                        $selected = ($year === $currentYear) ? 'selected' : '';
                                                        echo "<option value='{$year}' {$selected}>{$year}</option>";
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row">

                                        <div class="col-lg-4 col-4 mb2">

                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" value="harian"
                                                    id="filter-harian" name="waktu" />
                                                <label class="form-check-label" for="defaultRadio1"> Harian </label>
                                            </div>
                                        </div>
                                        <div
                                            class="col-lg-4 col-4 d-flex align-items-center justify-content-start mb-2">
                                            <input type="date" class="form-control " id="tanggal-input" name="tgl_awal">
                                        </div>

                                        <div
                                            class="col-lg-4 col-4 d-flex align-items-center justify-content-start mb-2">
                                            <input type="date" class="form-control " id="tanggal-input2"
                                                name="tgl_akhir">
                                        </div>
                                    </div>

                                </div>
                                <div class="col-lg-4 col-12 d-flex align-items-center justify-content-start mt-4 mb-4">
                                    <button type="submit" class="btn btn-primary" id="tampilkan">Tampilkan</button>
                                </div>


                            </div>
                        </form>
                    </div>
                    <div class="col-lg-3 col-12">
                        <div class="row">
                            <div class="col-lg-12 mb-2">
                                <div class="card border">
                                    <div class="card-header">
                                        <h6 class="card-title">Saldo Tersedia</h6>
                                        <h4><sup> Rp.</sup> <?php echo e(number_format($dataSantri['saldo'], 0, ',', '.')); ?></h4>
                                    </div>

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <div class="card mt-3">
        <div class="card-body">
            <div class="row justify-content-start">
                <h5>Histori Settlement <p class="float-end">
                        
                        <?php if($cek['cekPending2'] >= 1): ?>
                        <a href="#" class="btn btn-info" data-bs-toggle="modal" data-bs-target="#reqGagal"><i
                                class="bx bx-plus"></i> Tarik Saldo</a>
                        <?php elseif($cek['cekPending'] >= 2): ?>
                        <a href="#" class="btn btn-info" data-bs-toggle="modal" data-bs-target="#reqGagal2"><i
                                class="bx bx-plus"></i> Tarik Saldo</a>
                        <?php else: ?>
                        <a href="#" class="btn btn-info" data-bs-toggle="modal" data-bs-target="#tarik"><i
                                class="bx bx-plus"></i> Tarik Saldo</a>
                        <?php endif; ?>



                        
                    </p>
                </h5>
                <div class="table-responsive text-nowrap">

                    <table class="table table-hover table-striped table-sm display" id="logTable">
                        <thead>
                            <tr>

                                <th>No</th>
                                <th>Kode</th>
                                <th>Tanggal</th>
                                <th>Nama Admin</th>
                                <th>Branch</th>
                                <th>Nominal</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <!-- <tbody class="table-border-bottom-0">

                            </tbody> -->
                    </table>


                    </form>
                </div>
            </div>

        </div>
    </div>
</div>
<?php $__env->startPush('show-modal'); ?>
<div class="modal fade" id="tarik" aria-labelledby="modalToggleLabel" tabindex="-1" style="display: none"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    Tarik Saldo
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="formAccountSettings" action="<?php echo e(route('institution.settlement.save')); ?>" method="POST"
                    enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col mb-3">
                            <label for="">Nama Bank*</label>
                            <input type="text" class="form-control" name="nama_bank" id="nama_bank" required
                                oninvalid="this.setCustomValidity('Nama Bank tidak boleh kosong!')"
                                oninput="setCustomValidity('')">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col mb-3">
                            <label for="">No. Rekening*</label>
                            <input type="number" class="form-control" name="no_rek" id="no_rek" required
                                oninvalid="this.setCustomValidity('No Rekening tidak boleh kosong!')"
                                oninput="setCustomValidity('')">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col mb-3">
                            <label for="">Nama Pemilik Rekening*</label>
                            <input type="text" class="form-control" name="nama_pemilik" id="nama_pemilik" required
                                oninvalid="this.setCustomValidity('Nama Pemilik Rekening tidak boleh kosong!')"
                                oninput="setCustomValidity(''); this.value = this.value.toUpperCase();">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col mb-3">
                            <label for="">Nominal*</label>
                            <div class="input-group">
                                <span class="input-group-text">Rp</span>
                                <input type="text" class="form-control" name="nominal" id="nominal" required
                                    oninvalid="this.setCustomValidity('Nominal tidak boleh kosong!')"
                                    oninput="setCustomValidity('')">
                            </div>
                            <small><span id="terbilang"></span></small>

                        </div>
                    </div>
                    <small><span id="alert"></span></small>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    Batal
                </button>
                <input type="text" name="id_user" id="id_user" value="<?php echo e($dataSantri['id_user']); ?>" hidden>
                <input type="submit" name="Simpan" class="btn btn-primary" value="Request">

            </div>
            </form>
        </div>
    </div>
</div>
<div class=" modal fade" id="reqGagal" aria-labelledby="modalToggleLabel" tabindex="-1" style="display: none"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    Request Gagal!
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Mohon maaf, anda tidak dapat melakukan settlement karena masih ada status PENDING. Silahkan hubungi
                Admin Cabang untuk informasi lebih lanjut.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>
<div class=" modal fade" id="reqGagal2" aria-labelledby="modalToggleLabel" tabindex="-1" style="display: none"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    Request Gagal!
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                Mohon maaf, anda tidak dapat melakukan settlement karena Limit Mingguan Penarikan sudah habis. Silahkan
                hubungi
                Admin Cabang untuk informasi lebih lanjut.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal Detail STL -->
<div class="modal fade" id="detailSTL" tabindex="-1" aria-labelledby="detailSTLLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="detailSTLLabel">Details Request</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <table class="table table-sm table-hover table-striped">
                    <tr>
                        <td width="25%">Nama Bank</td>
                        <td width="2%">:</td>
                        <th><span class="modal-nama-bank"></span></th>
                    </tr>
                    <tr>
                        <td width="25%">No. Rekening</td>
                        <td width="2%">:</td>
                        <th><span class="modal-no-rek"></span></th>
                    </tr>
                    <tr>
                        <td width="25%">Nama Pemilik</td>
                        <td width="2%">:</td>
                        <th><span class="modal-nama-pemilik"></span></th>
                    </tr>
                    <tr>
                        <td width="25%">Nominal</td>
                        <td width="2%">:</td>
                        <th><span class="modal-nominal"></span></th>
                    </tr>
                    <tr>
                        <td width="25%">Verifikator</td>
                        <td width="2%">:</td>
                        <th><span class="modal-verifikator"></span></th>
                    </tr>
                </table>

            </div>
            <div class=" modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('assets/vendor/libs/dataTables/dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/dataTables/dataTables.bootstrap5.min.js')); ?>"></script>
<script src="https://cdn.datatables.net/buttons/1.7.1/js/dataTables.buttons.min.js"></script>

<script>
    const filterBulanan = document.getElementById('filter-bulanan');
    const filterHarian = document.getElementById('filter-harian');
    const bulanSelect = document.getElementById('bulan-select');
    const tahunSelect = document.getElementById('tahun-select');
    const tanggalInput = document.getElementById('tanggal-input');
    const tanggalInput2 = document.getElementById('tanggal-input2');
    const submitButton = document.getElementById('tampilkan');

    // Fungsi untuk mendapatkan tanggal hari ini dalam format YYYY-MM-DD
    function getTodayDate() {
        const today = new Date();
        const year = today.getFullYear();
        const month = String(today.getMonth() + 1).padStart(2, '0');
        const day = String(today.getDate()).padStart(2, '0');
        return `${year}-${month}-${day}`;
    }

    // Fungsi untuk mendapatkan bulan dan tahun saat ini
    function getCurrentMonthYear() {
        const today = new Date();
        return {
            month: today.getMonth() + 1, // getMonth() returns 0-11
            year: today.getFullYear()
        };
    }

    filterBulanan.addEventListener('change', function() {
        if (this.checked) {
            bulanSelect.disabled = false;
            tahunSelect.disabled = false;
            tanggalInput.disabled = true;
            tanggalInput2.disabled = true;
            
            // Reset nilai input tanggal
            tanggalInput.value = '';
            tanggalInput2.value = '';
            
            // Set bulan dan tahun saat ini
            const current = getCurrentMonthYear();
            bulanSelect.value = current.month;
            
            // Cari dan set opsi tahun saat ini
            const currentYear = current.year.toString();
            for(let i = 0; i < tahunSelect.options.length; i++) {
                if(tahunSelect.options[i].value === currentYear) {
                    tahunSelect.selectedIndex = i;
                    break;
                }
            }
            
            // Enable tombol submit
            submitButton.disabled = false;
        }
    });

    filterHarian.addEventListener('change', function() {
        if (this.checked) {
            bulanSelect.disabled = true;
            tahunSelect.disabled = true;
            tanggalInput.disabled = false;
            tanggalInput2.disabled = false;
            
            // Set tanggal hari ini secara otomatis
            const today = getTodayDate();
            tanggalInput.value = today;
            tanggalInput2.value = today;
            
            // Reset nilai bulan dan tahun
            bulanSelect.value = '';
            tahunSelect.selectedIndex = 0;
            
            // Enable tombol submit
            submitButton.disabled = false;
        }
    });

    // Set default state saat halaman dimuat
    window.addEventListener('DOMContentLoaded', function() {
        // Disable submit button initially
        submitButton.disabled = true;
        
        // Disable all inputs initially
        bulanSelect.disabled = true;
        tahunSelect.disabled = true;
        tanggalInput.disabled = true;
        tanggalInput2.disabled = true;
    });
</script>

<script>
    $(document).ready(function() {
       
        var url = '<?= route('institution.settlement.edu'); ?>/?cabang=<?php echo e($dataSantri['cabang']); ?>&id_nasabah=<?php echo e($dataSantri['idnasabah']); ?>';
        // var url = 'http://localhost:8080/merchant/trxSettlementEdu/?cabang=<?php echo e($dataSantri['cabang']); ?>&id_nasabah=<?php echo e($dataSantri['idnasabah']); ?>';
        console.log(url);
        var urlParams = new URLSearchParams(window.location.search);
        var bulan = urlParams.get('bulan');
        var tahun = urlParams.get('tahun');
        var tgl_awal = urlParams.get('tgl_awal');
        var tgl_akhir = urlParams.get('tgl_akhir');

        if (bulan && tahun) {
            url += '&bulan=' + bulan + '&tahun=' + tahun;
        }

        if (tgl_awal && tgl_akhir) {
            url += (url.indexOf('?') !== -1 ? '&' : '?') + 'tgl_awal=' + tgl_awal + '&tgl_akhir=' + tgl_akhir;
        }

        $('#logTable').DataTable({
            pageLength: 25,
            ajax: {
                url: url,
                dataSrc: function(json) {
                    if (json.data.length === 0) {
                        $('#logTable3').html('<tr><td colspan="8" class="text-center">Data tidak ditemukan</td></tr>');
                    }
                    return json.data;
                }
            },
            columns: [{
                    data: null,
                    render: function(data, type, row, meta) {
                        var rowIndex = meta.row + meta.settings._iDisplayStart + 1;
                        return rowIndex;
                    }
                },

                {
                    data: 'kode'
                },
                {
                    data: 'tanggal'
                },
                {
                    data: 'first_name',

                },
                {
                    data: 'nama_cabang'
                },
                {
                    data: 'nominal',
                    render: function(data, type, row) {
                        var formattedAmount = data ? 'Rp. ' + parseInt(data).toLocaleString().replace(/,/g, '.') : '-';
                        return formattedAmount;
                    }

                },

                {
                    data: 'status',
                    render: function(data, type, row) {
                        if (data == 0) {
                            return '<span class="badge bg-label-warning">Pending</span>';
                        } else if (data == 1) {
                            return '<span class="badge bg-label-primary">Sukses</span>';
                        } else {
                            return '-';
                        }
                    }

                },
                {
                    data: null,
                    render: function(data, type, row) {
                        return '<a href="" data-bs-toggle="modal" data-bs-target="#detailSTL" data-no-rek="' + row.no_rek + '" data-nominal="' + row.nominal + '" data-nama-bank="' + row.nama_bank + '" data-verifikator="' + row.verifikator + '" data-nama-pemilik="' + row.nama_pemilik + '"><i class="bx bxs-message-square-detail"></i></a>';
                       
                    }

                },
            ],
            order: [
                [1, 'desc']
            ],
            language: {
                emptyTable: 'Maaf, tidak ada data yang bisa ditampilkan!'
            }
        });
    });
</script>
<script>
    $(document).ready(function() {
        var tglAwalInput = document.getElementById('tanggal-input');
        var tglAkhirInput = document.getElementById('tanggal-input2');


        tglAwalInput.addEventListener('change', function() {

            tglAkhirInput.min = tglAwalInput.value;
            tglAkhirInput.disabled = false;
        });

        tglAkhirInput.addEventListener('change', function() {

            if (tglAwalInput.value > tglAkhirInput.value) {
                alert('Tanggal akhir harus lebih besar dari tanggal awal');
                tglAkhirInput.value = '';
            }
        });
    });
</script>
<script>
    var nominalInput = document.getElementById('nominal');
    nominalInput.addEventListener('input', function() {
        var nominalValue = this.value.replace(/[^0-9]/g, '');
        var formattedNominal = addThousandSeparator(nominalValue);
        this.value = formattedNominal;
    });

    function addThousandSeparator(value) {
        return value.toString().replace(/\B(?=(\d{3})+(?!\d))/g, '.');
    }
</script>
<script>
    $('#detailSTL').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget);
        var no_rek = button.data('no-rek');
        var nama_bank = button.data('nama-bank');
        var nama_pemilik = button.data('nama-pemilik');
        var nominal = button.data('nominal');
        var verifikator = button.data('verifikator');

        var modal = $(this);
        modal.find('.modal-no-rek').text(no_rek);
        modal.find('.modal-nama-bank').text(nama_bank);
        modal.find('.modal-nama-pemilik').text(nama_pemilik);
        modal.find('.modal-nominal').text(nominal);
        modal.find('.modal-verifikator').text(verifikator);
    });
</script>
<script>
    $(document).ready(function() {
        $('#detailSTL').on('show.bs.modal', function() {
            var nominal = parseFloat($(this).find('.modal-nominal').text());
            var formattedSaldo = 'Rp. ' + nominal.toLocaleString('id-ID') + ',-';
            $(this).find('.modal-nominal').text(formattedSaldo);
        });
    });
</script>
<script>
    $(document).ready(function() {
        $('#tarik').on('shown.bs.modal', function() {
            var saldoTersedia = parseFloat("<?php echo e($dataSantri['saldo']); ?>"); 
            $('#nominal').on('input', function() {
                var nominalValue = $(this).val().replace(/\./g, ''); // Menghilangkan titik dari input
                var submitButton = $('input[name="Simpan"]');

                if (isNaN(nominalValue) || parseFloat(nominalValue) > saldoTersedia) {
                    $(this).addClass('is-invalid');
                    submitButton.prop('disabled', true);
                    $('#alert').text('*) Nominal melebihi saldo yang tersedia');
                } else {
                    $(this).removeClass('is-invalid');
                    submitButton.prop('disabled', false);
                    $('#alert').text('');
                }
            });

            // Menggunakan event submit pada form untuk memeriksa saat tombol submit ditekan
            $('form').on('submit', function(e) {
                var nominalValue = $(this).val().replace(/\./g, ''); // Menghilangkan titik dari input

                if (isNaN(nominalValue) || parseFloat(nominalValue) > saldoTersedia) {
                    e.preventDefault(); // Mencegah submit form
                    $('#nominal').addClass('is-invalid');
                    $('#alert').text('Nominal melebihi saldo yang tersedia');
                }
            });
        });
    });
</script>
<script>
    $(document).ready(function() {
        $('#tarik').on('shown.bs.modal', function() {
            $('#nominal').on('input', function() {
                var nominal = $(this).val().replace(/\./g, ''); // Menghapus tanda titik (.)
                var terbilang = convertToTerbilang(nominal);
                $('#terbilang').text(terbilang + ' rupiah');
            });

            function convertToTerbilang(number) {
                var terbilang = '';
                var words = [
                    '', 'satu', 'dua', 'tiga', 'empat', 'lima', 'enam', 'tujuh', 'delapan', 'sembilan',
                    'sepuluh', 'sebelas', 'dua belas', 'tiga belas', 'empat belas', 'lima belas',
                    'enam belas', 'tujuh belas', 'delapan belas', 'sembilan belas'
                ];

                if (number < 20) {
                    terbilang = words[number];
                } else if (number < 100) {
                    terbilang = words[Math.floor(number / 10)] + ' puluh ' + words[number % 10];
                } else if (number < 200) {
                    terbilang = 'seratus ' + convertToTerbilang(number % 100);
                } else if (number < 1000) {
                    terbilang = words[Math.floor(number / 100)] + ' ratus ' + convertToTerbilang(number % 100);
                } else if (number < 2000) {
                    terbilang = 'seribu ' + convertToTerbilang(number % 1000);
                } else if (number < 1000000) {
                    terbilang = convertToTerbilang(Math.floor(number / 1000)) + ' ribu ' + convertToTerbilang(number % 1000);
                } else if (number < 1000000000) {
                    terbilang = convertToTerbilang(Math.floor(number / 1000000)) + ' juta ' + convertToTerbilang(number % 1000000);
                } else if (number < 1000000000000) {
                    terbilang = convertToTerbilang(Math.floor(number / 1000000000)) + ' miliar ' + convertToTerbilang(number % 1000000000);
                } else {
                    terbilang = 'Angka terlalu besar';
                }

                return terbilang;
            }
        });
    });
</script>
<script>
    <?php if(session('message')): ?>
   
        Swal.fire(
            'Permintaan Tarik Saldo, Berhasil!',
            'Mohon tunggu konfirmasi dari Admin, Proses ini bisa memakan waktu maksimal 3x24 jam',
            'success'
        )
    <?php endif; ?>

    <?php if(session('error')): ?>
        toastr.error("<?php echo e(session('error')); ?>");
    <?php endif; ?>
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u1571340/public_html/edupay/edupay/resources/views/pages/institution/settlement/index.blade.php ENDPATH**/ ?>