<?php $__env->startSection('title'); ?>
    Santri
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php $__env->startPush('css'); ?>
        <link rel="stylesheet" href="<?php echo e(asset('./assets/vendor/libs/select2/select2.css')); ?>">
        </link>
        <link rel="stylesheet"
            href="https://cdn.jsdelivr.net/npm/@ttskch/select2-bootstrap4-theme@x.x.x/dist/select2-bootstrap4.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
    <?php $__env->stopPush(); ?>
    <div class="d-flex justify-content-between align-items-center">
        <h4 class="py-3 mb-4">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="/">Dashboard</a>
                    </li>
                    <li class="breadcrumb-item active">Manajemen Santri</li>
                </ol>
            </nav>
        </h4>
        <div class="d-flex gap-2 align-items-center">
            <a class="btn btn-outline-warning" href="<?php echo e(route('institution.student.export')); ?>">
                <span class='tf-icons bx bxs-file-export me-1'></span>
                Export
            </a>
            <button class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#student-import-modal">
                <span class='tf-icons bx bxs-file-import m-1'></span>
                Import
            </button>
        </div>
    </div>
    <div class="row">
        <div class="col">
            <?php if(session()->has('failures')): ?>
                <div class="alert alert-danger border border-danger alert-dismissible" role="alert">
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                    </button>
                    <table class="table table-bordered border-danger py-4">
                        <thead>
                            <tr>
                                <th>Baris</th>
                                <th>Atribut</th>
                                <th>Error</th>
                                <th>Value</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = session('failures'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $failure): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($failure->row()); ?></td>
                                    <td><?php echo e($failure->attribute()); ?></td>
                                    <td>
                                        <ul>
                                            <?php $__currentLoopData = $failure->errors(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($error); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </td>
                                    <td>
                                        <ul>
                                            <?php $__currentLoopData = $failure->values(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($value); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
            <?php echo $__env->make('components.alert-data-manage', [], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card">
                <div class="card-body">
                    <?php if (isset($component)) { $__componentOriginaldf255275b6fbe6231a820684a50d98f458669d70 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\BasicDataTable::class, ['id' => $idStudentTable,'routeDelete' => route('institution.student.destroy'),'headers' => $headers,'rows' => $rows]); ?>
<?php $component->withName('basic-data-table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldf255275b6fbe6231a820684a50d98f458669d70)): ?>
<?php $component = $__componentOriginaldf255275b6fbe6231a820684a50d98f458669d70; ?>
<?php unset($__componentOriginaldf255275b6fbe6231a820684a50d98f458669d70); ?>
<?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php $__env->startPush('show-modal'); ?>
        <?php
            $formModal = 'formClassModal';
        ?>
        
        <?php if (isset($component)) { $__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ShowModal::class, ['id' => $formModal]); ?>
<?php $component->withName('show-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
            <div class="modal-header">
                <h5 class="modal-title" id="modalToggleLabel">
                    <div id="modalToggleLabel2"></div>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="<?php echo e(route('institution.student.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('POST'); ?>
                    <div class="row">
                        <?php echo $__env->make('components.field', [
                            'label' => 'NIS',
                            'name' => 'nis',
                            'placeholder' => '201200001',
                            'type' => 'text',
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('components.field', [
                            'label' => 'Nama Lengkap',
                            'name' => 'name',
                            'placeholder' => 'ABDULLAH AL-ARIF',
                            'type' => 'text',
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('components.field', [
                            'label' => 'Kelas',
                            'name' => 'school_class',
                            'type' => 'select',
                            'options' => $educational_levels->map(function ($educational_level) {
                                    return '<optgroup label="' .
                                        $educational_level->name .
                                        '">' .
                                        $educational_level->schoolClasses->map(function ($school_class) {
                                                return '<option value="' . $school_class->id . '">' . $school_class->name . '</option>';
                                            })->join(' ') .
                                        '</optgroup>';
                                })->join(' '),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('components.field', [
                            'label' => 'No Telephone',
                            'name' => 'phone',
                            'placeholder' => '0856 xxxx xxxx',
                            'type' => 'text',
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    Batal
                </button>
                <button type="submit" class="btn btn-primary">
                    Simpan
                </button>
            </div>
            </form>
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286)): ?>
<?php $component = $__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286; ?>
<?php unset($__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286); ?>
<?php endif; ?>
        <?php if (isset($component)) { $__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\ShowModal::class, ['id' => 'student-import-modal']); ?>
<?php $component->withName('show-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
            <div class="modal-header">
                <h5 class="modal-title" id="backDropModalTitle">Import Santri</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="<?php echo e(route('institution.student.import')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('POST'); ?>
                    <div class="row">
                        <div class="col">
                            <input class="form-control skeleton" type="file" id="formFile" name="santri_file" accept=".xlsx"
                                required />
                        </div>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    Batal
                </button>
                <a class="btn btn-info" href="<?php echo e(route('institution.student.importFormat')); ?>">
                    Unduh Format
                </a>
                <button type="submit" class="btn btn-primary">
                    Import
                </button>
            </div>
            </form>
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286)): ?>
<?php $component = $__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286; ?>
<?php unset($__componentOriginaldfb39536dd2899263d8a002874c0b4edccbc4286); ?>
<?php endif; ?>
    <?php $__env->stopPush(); ?>
    <?php $__env->startPush('js'); ?>
        
        <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
        <!-- Include Utils -->
        <script src="<?php echo e(asset('assets/js/utils.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/js/basic-table-ajax.js')); ?>"></script>
        <script>
            $(document).ready(function() {
                let idTable = "#:id".replace(":id", "<?php echo e($idStudentTable); ?>");
                let idFormModal = "#:id".replace(":id", "<?php echo e($formModal); ?>");

                $("#school_class").select2({
                    dropdownParent: $('#' + "<?php echo e($formModal); ?>")
                });

                BasicDataTable.initializeDataTable({
                    storeUrl: "<?php echo e(route('institution.student.store')); ?>",
                    editUrl: "<?php echo e(route('institution.student.edit', ':id')); ?>",
                    updateUrl: "<?php echo e(route('institution.student.update', ':id')); ?>",
                    showUrl: {
                        show: "<?php echo e(route('institution.student.show', ':id')); ?>",
                    },
                    idTable: $(idTable),
                    idFormModal: $(idFormModal),
                    headerActionsPosition: 6,
                    requestServer: function(data) {
                        $('#' + '<?php echo e($formModal); ?>').find('input[name="_method"]').val('PUT')
                        $('input[name="nis"]').val(data.nis)
                        $('input[name="name"]').val(data.name)
                        $('select[name="school_class"]').val(data.school_class_id).change()
                        $('input[name="phone"]').val(data.phone)
                    },
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bsnc2936/public_html/edupay/resources/views/pages/institution/manage-data/student/index.blade.php ENDPATH**/ ?>