

<?php $__env->startSection('content'); ?>
<div class="row">
    <h4 class="py-3 mb-4">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="/">Dashboard</a>
                </li>
                <li class="breadcrumb-item active">Naik Kelas</li>
            </ol>
        </nav>
    </h4>
    <div class="col">
        <?php echo $__env->make('components.alert-data-manage', [], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="card">
            <div class="card-body">
                <!-- disini tabel nya -->
                <form id="filter" method="GET">
                    <div class="row">
                        <span class="mb-2">Filter Data</span>

                        <div class="col-md-3 mb-2">

                            <select name="jenjang" id="jenjang" class="form-control" required>
                                <option value="">Pilih Jenjang</option>

                                <?php $__currentLoopData = $jenjang; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $j): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($j->id); ?>"><?php echo e($j->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="col-md-2 mb-2 ">

                            <select name="kelas" id="kelas" class="form-control" required>
                                <option value="">Pilih Kelas</option>


                            </select>
                        </div>
                        <div class="col-md-2 mb-2">

                            <select name="status" id="status" class="form-control" required>
                                <option value="">Pilih Status</option>
                                <option value="Aktif">Aktif</option>
                                <option value="Lulus">Lulus</option>

                            </select>
                        </div>


                        <div class="col-md-3 mb-2">

                            <button type="submit" id="submit_cc" class="btn btn-primary"><i class="bx bx-search"></i> Cari</button>
                        </div>
                </form>

            </div>
        </div>
    </div>
</div>
<div id="datasiswa" class="mt-3" style="display: none;">
    <div class="row gy-3">
        <div class="col-lg-9">
            <div class="card pb-3 pt-4 px-3">
                <div class="table-responsive text-nowrap">

                    <form id="gantiStatus" action="<?php echo e(route('institution.gantiStatus')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <table class="table table-hover table-striped table-sm" id="table1">
                            <thead>
                                <tr>

                                    <th width="5%"><input type="checkbox" class="form-check-input" id="selectall" value="checkbox" name="checkbox"></th>
                                    <th width="5%">No</th>

                                    <th>NIS</th>
                                    <th>Nama</th>
                                    <th>Jenjang</th>
                                    <th>Kelas</th>
                                    <th>Status</th>
                                </tr>
                            </thead>

                            <tbody class="table-border-bottom-0">

                            </tbody>
                        </table>

                </div>
            </div>
        </div>
        <div class="col-lg-3">
            <div class="card pb-3 pt-4 px-3">
                <div class="row">

                    <div class="col-12 mb-2">
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="pilihan" id="pilihan1" value="Pindah">
                            <label class="form-check-label" for="pilihan1">
                                Pindah Kelas
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="pilihan" id="pilihan2" value="Lulus">
                            <label class="form-check-label" for="pilihan2">
                                Lulus
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="pilihan" id="pilihan3" value="Aktif">
                            <label class="form-check-label" for="pilihan3">
                                Batal Lulus
                            </label>
                        </div>
                    </div>
                    <div class="col-12 mb-2">
                        <select name="jenjang" id="jenjang2" class="form-control">
                            <option value="">Pilih Jenjang</option>
                            <?php $__currentLoopData = $jenjang; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $j): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($j->id); ?>"><?php echo e($j->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-12 mb-2">
                        <select name="kelas" id="kelas2" class="form-control">
                            <option value="">Pilih Kelas</option>


                        </select>
                    </div>
                    <div class="d-grid gap-2 col-lg-12 mx-auto">


                        <button type="submit" class="btn btn-primary" id="pindahKelas3" disabled>Simpan</button>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<!-- <?php $__env->startPush('show-modal'); ?>
<?php
$formModal = 'formClassModal';
?>


<?php $__env->stopPush(); ?>
<?php $__env->startPush('js'); ?> -->
<!-- Include Utils -->
<script src="<?php echo e(asset('assets/js/utils.js')); ?>"></script>
<!-- Setup Custom DataTable Lib -->
<script src="<?php echo e(asset('assets/js/basic-table-ajax.js')); ?>"></script>
<script>
    $(document).ready(function() {
        $('#jenjang').on('change', function() {
            var jenjangId = $(this).val();
            $('#kelas').html('<option value="">Loading...</option>'); // Tampilkan loading sementara

            if (jenjangId) {
                $.ajax({
                    url: '<?php echo e(route("institution.getKelasByJenjang")); ?>',
                    type: 'GET',
                    data: {
                        jenjang_id: jenjangId
                    },
                    success: function(data) {
                        var kelasOptions = '<option value="">Pilih Kelas</option>';
                        $.each(data, function(key, value) {
                            kelasOptions += '<option value="' + value.id + '">' + value.name + '</option>';
                        });
                        $('#kelas').html(kelasOptions); // Update select kelas
                    }
                });
            } else {
                $('#kelas').html('<option value="">Pilih Kelas</option>'); // Reset jika tidak ada pilihan
            }
        });
    });
    $(document).ready(function() {
        $('#jenjang2').on('change', function() {
            var jenjangId = $(this).val();
            $('#kelas2').html('<option value="">Loading...</option>'); // Tampilkan loading sementara

            if (jenjangId) {
                $.ajax({
                    url: '<?php echo e(route("institution.getKelasByJenjang")); ?>',
                    type: 'GET',
                    data: {
                        jenjang_id: jenjangId
                    },
                    success: function(data) {
                        var kelasOptions = '<option value="">Pilih Kelas</option>';
                        $.each(data, function(key, value) {
                            kelasOptions += '<option value="' + value.id + '">' + value.name + '</option>';
                        });
                        $('#kelas2').html(kelasOptions); // Update select kelas
                    }
                });
            } else {
                $('#kelas2').html('<option value="">Pilih Kelas</option>'); // Reset jika tidak ada pilihan
            }
        });
    });
</script>
<script>
    $(document).ready(function() {
        $('#filter').on('submit', function(e) {
            e.preventDefault(); // Mencegah reload halaman
            $('#submit_cc').html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Cari');
            $('#datasiswa').show();
            var kelas = $('#kelas').val();
            var status = $('#status').val();

            $.ajax({
                url: '<?php echo e(route("institution.getStudents")); ?>',
                type: 'GET',
                data: {
                    kelas: kelas,
                    status: status
                },
                success: function(data) {
                    var rows = '';
                    if (data.length > 0) {
                        $.each(data, function(index, student) {
                            rows += '<tr>';
                            rows += '<td><input type="checkbox" class="form-check-input" name="selected_students[]" value="' + student.id + '"></td>';
                            rows += '<td>' + (index + 1) + '</td>';
                            rows += '<td>' + student.nis + '</td>';
                            rows += '<td>' + student.name + '</td>';
                            rows += '<td>' + (student.school_class && student.school_class.educational_level ? student.school_class.educational_level.name : '-') + '</td>';
                            rows += '<td>' + (student.school_class ? student.school_class.name : '-') + '</td>';
                            rows += '<td>' + student.status + '</td>';
                            rows += '</tr>';
                        });
                    } else {
                        rows = '<tr><td colspan="7" class="text-center">Tidak ada data</td></tr>';
                    }
                    $('#table1 tbody').html(rows); // Update tabel dengan hasil data
                    $('#submit_cc').html('<i class="bx bx-search"></i> Cari');
                }
            });
        });

        // Checkbox Select All
        $('#selectall').on('click', function() {
            $('input[name="selected_students[]"]').prop('checked', this.checked);
        });
    });
</script>

<script>
    $(document).ready(function() {
        // Sembunyikan select box saat halaman dimuat
        $('#jenjang2, #kelas2').hide();

        // Event saat radio button berubah
        $('input[name="pilihan"]').change(function() {
            let selectedValue = $('input[name="pilihan"]:checked').val();

            // Jika "Pindah Kelas" dipilih, tampilkan select box
            if (selectedValue === 'Pindah') {
                $('#jenjang2, #kelas2').show();
            } else {
                $('#jenjang2, #kelas2').hide().val('');
            }

            validateForm(); // Cek validasi setiap kali pilihan berubah
        });

        // Event saat select box berubah
        $('#jenjang2, #kelas2').change(function() {
            validateForm();
        });

        // Fungsi untuk validasi form
        function validateForm() {
            let selectedValue = $('input[name="pilihan"]:checked').val();
            let jenjang = $('#jenjang2').val();
            let kelas = $('#kelas2').val();

            let isValid = selectedValue !== undefined;

            if (selectedValue === 'Pindah') {
                isValid = isValid && jenjang !== '' && kelas !== '';
            }

            $('#pindahKelas3').prop('disabled', !isValid);
        }

        // Panggil validasi saat halaman dimuat
        validateForm();

        // Tambahkan event untuk tombol simpan
        $('#pindahKelas3').click(function(event) {
            event.preventDefault(); // Mencegah form terkirim langsung

            Swal.fire({
                title: "Konfirmasi",
                text: "Apakah Anda yakin ingin melakukan perubahan ini?",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Ya, Lanjutkan!",
                cancelButtonText: "Batal"
            }).then((result) => {
                if (result.isConfirmed) {
                    $('#gantiStatus').submit(); // Kirim form jika dikonfirmasi
                }
            });
        });
    });
</script>

<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dashboard', ['title' => 'Kelas'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bsnc2936/public_html/edupay/resources/views/pages/institution/manage-data/naik-kelas/index.blade.php ENDPATH**/ ?>