<div class="table-responsive">
    <table class="table table-responsive p-2" id="<?php echo e($id); ?>" style="width: 100%">
        <thead>
            <tr>
                <td width="2%">
                    <input type="checkbox" class="dt-checkboxes form-check-input head-cb" style="height: 16px; width: 16px;"
                        name="ids[]">
                </td>
                <th>#</th>
                <th>Nama</th>
                <th>Nominal</th>
                <th><?php echo e($status == 'BILLED' ? 'Aktif' : 'Lunas'); ?></th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $groupedBillDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $billId => $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $statusDetails = $details->firstWhere('status', $status);
                ?>

                <?php if($statusDetails): ?>
                    <?php
                        $totalAmount = $details->where('status', $status)->sum('amount');
                        $tableCount++;

                        $actived_at = $statusDetails->actived_at
                            ? ($details->where('status', $status)->count() > 1
                                ? '-'
                                : carbon()
                                    ->parse($statusDetails->actived_at)
                                    ->format('d M y'))
                            : '-';
                        $paid_at =
                            $details->where('status', $status)->count() > 1
                                ? '-'
                                : carbon()
                                    ->parse($statusDetails->paid_at)
                                    ->format('d M y');
                    ?>
                    <tr>
                        <td width="2%">
                            <input type="checkbox" class="dt-checkboxes child-cb form-check-input"
                                style="height: 16px; width: 16px;" name="ids[]" value="<?php echo e($statusDetails->id); ?>">
                        </td>
                        <td><?php echo e($tableCount); ?></td>
                        <td><?php echo e($statusDetails->bill->name); ?></td>
                        <td>Rp<?php echo e(number_format($totalAmount, 0, '.', '.')); ?>, -</td>
                        <td>
                            <?php echo e($status != 'PAID' ? $actived_at : $paid_at); ?>

                        </td>
                        <td>
                            <?php if($status != 'PAID'): ?>
                                <a href="<?php echo e(route('institution.student-bill.edit', [$statusDetails->student_id, $statusDetails->bill_id])); ?>"
                                    class="btn btn-icon text-primary item-edit"
                                    data-student="<?php echo e($statusDetails->student_id); ?>"
                                    data-bill="<?php echo e($statusDetails->bill_id); ?>"><i class="bx bxs-edit bx-sm"></i></a>
                                <a href="javascript:;" class="btn btn-icon text-danger item-delete"
                                    data-delete="<?php echo e($statusDetails->id); ?>" data-status="<?php echo e($status); ?>"
                                    data-bs-toggle="modal" data-bs-target="#modal-confirm"><i
                                        class="bx bxs-trash bx-sm"></i></a>
                            <?php endif; ?>
                            <?php echo $details->where('status', $status)->count() > 1
                                ? '<a href="#" class="btn btn-icon text-info btn-show-details" data-bs-toggle="modal" data-bs-target="#billDetailsModal" data-id="' .
                                    $statusDetails->bill_id .
                                    '" data-status="' .
                                    $status .
                                    '" data-student="' .
                                    $statusDetails->student_id .
                                    '"><i class="bx bxs-show bx-sm"></i></a>'
                                : ''; ?>

                            <?php echo $details->where('status', $status)->count() < 2 &&
                            $details->where('status', $status)->first()->bill->bill_category_id == 2 &&
                            $status != 'PAID'
                                ? '<a href="#" class="btn btn-sm btn-primary btn-show-cicil" data-bs-toggle="modal" data-bs-target="#billCicilModal" data-id="' .
                                    $statusDetails->bill_id .
                                    '" data-status="' .
                                    $status .
                                    '" data-student="' .
                                    $statusDetails->student_id .
                                    '">CICIL</a>'
                                : ''; ?>

                        </td>
                    </tr>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>

<?php $__env->startPush('css'); ?>
<style>
    .table-responsive {
        overflow-x: auto;
    }
    
    #<?php echo e($id); ?> th,
    #<?php echo e($id); ?> td {
        white-space: nowrap;
    }

    #<?php echo e($id); ?> th:first-child,
    #<?php echo e($id); ?> td:first-child { min-width: 40px; }  /* Checkbox */
    #<?php echo e($id); ?> th:nth-child(2),
    #<?php echo e($id); ?> td:nth-child(2) { min-width: 50px; }  /* No */
    #<?php echo e($id); ?> th:nth-child(3),
    #<?php echo e($id); ?> td:nth-child(3) { min-width: 200px; } /* Nama */
    #<?php echo e($id); ?> th:nth-child(4),
    #<?php echo e($id); ?> td:nth-child(4) { min-width: 150px; } /* Nominal */
    #<?php echo e($id); ?> th:nth-child(5),
    #<?php echo e($id); ?> td:nth-child(5) { min-width: 120px; } /* Tanggal */
    #<?php echo e($id); ?> th:last-child,
    #<?php echo e($id); ?> td:last-child { min-width: 100px; } /* Actions */
</style>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\xampp\htdocs\edupay\edupay\resources\views/pages/institution/manage-data/student/sections/table.blade.php ENDPATH**/ ?>